/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.informix;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="INFORMIX", typeDescription="Informix", documentationUrl="/database/databases/informix.html")
@GuiPlugin(id="GUI-InformixDatabaseMeta")
public class InformixDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    @GuiWidgetElement(id="servername", order="10", parentId="DatabaseMeta-PluginSpecific-Options", type=GuiElementType.TEXT, variables=true, label="i18n:org.apache.hop.ui.core.database:DatabaseDialog.label.InformixServername")
    protected boolean servername;

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 1526;
        }
        return -1;
    }

    public int getNotFoundTK(boolean useAutoinc) {
        if (this.isSupportsAutoInc() && useAutoinc) {
            return 1;
        }
        return super.getNotFoundTK(useAutoinc);
    }

    public String getDriverClass() {
        return "com.informix.jdbc.IfxDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:informix-sqli://" + hostname + ":" + port + "/" + databaseName + ":INFORMIXSERVER=" + this.getServername() + ";DELIMIDENT=Y";
    }

    public boolean isNeedsPlaceHolder() {
        return true;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT FIRST 1 * FROM " + tableName;
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.getSqlQueryColumnFields(columnname, tableName);
    }

    public String getSqlQueryColumnFields(String columnname, String tableName) {
        return "SELECT FIRST 1 " + columnname + " FROM " + tableName;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        Object retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 9: {
                retval = (String)retval + "DATETIME";
                break;
            }
            case 3: {
                retval = (String)retval + "DATETIME YEAR to FRACTION";
                break;
            }
            case 4: {
                if (this.isSupportsBooleanDataType()) {
                    retval = (String)retval + "BOOLEAN";
                    break;
                }
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval = (String)retval + "SERIAL8";
                        break;
                    }
                    retval = (String)retval + "INTEGER PRIMARY KEY";
                    break;
                }
                if (type == 5) {
                    if (length < 5) {
                        retval = (String)retval + "SMALLINT";
                        break;
                    }
                    if (length < 10) {
                        retval = (String)retval + "INT";
                        break;
                    }
                    if (length < 20) {
                        retval = (String)retval + "BIGINT";
                        break;
                    }
                    retval = (String)retval + "DECIMAL(" + length + ",0)";
                    break;
                }
                if (type == 6) {
                    if (length < 1) {
                        length = 16;
                    }
                    if (precision < 1) {
                        precision = 16;
                    }
                    retval = (String)retval + "DECIMAL(" + length + "," + precision + ")";
                    break;
                }
                retval = (String)retval + "FLOAT";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = (String)retval + "CLOB";
                    break;
                }
                if (length < 256) {
                    retval = (String)retval + "VARCHAR";
                    if (length <= 0) break;
                    retval = (String)retval + "(" + length + ")";
                    break;
                }
                if (length < 32768) {
                    retval = (String)retval + "LVARCHAR";
                    break;
                }
                retval = (String)retval + "TEXT";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public String getSqlLockTables(String[] tableNames) {
        StringBuilder sql = new StringBuilder(128);
        for (String tableName : tableNames) {
            sql.append("LOCK TABLE " + tableName + " IN EXCLUSIVE MODE;" + Const.CR);
        }
        return sql.toString();
    }

    public String getSqlUnlockTables(String[] tableNames) {
        return null;
    }

    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + keyField + ", " + versionField + ") values (1, 1)";
    }

    public boolean isInformixVariant() {
        return true;
    }

    public void addDefaultOptions() {
        this.setSupportsBooleanDataType(true);
    }
}

