/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.map;

import java.util.Comparator;
import java.util.Iterator;
import org.psjava.ds.KeyValuePair;
import org.psjava.ds.map.MutableSortedMap;
import org.psjava.ds.tree.binary.bst.BinarySearchTree;
import org.psjava.ds.tree.binary.bst.InsertionResult;
import org.psjava.ds.tree.binary.bst.RemoveResult;
import org.psjava.util.AssertStatus;
import org.psjava.util.IterableToString;

public class MutableSortedMapUsingBinarySearchTree {
    public static <K, V> MutableSortedMap<K, V> create(final Comparator<K> comp) {
        return new MutableSortedMap<K, V>(){
            BinarySearchTree<K, V> tree;
            int size;
            {
                this.tree = new BinarySearchTree(comp);
                this.size = 0;
            }

            @Override
            public boolean containsKey(K key) {
                return this.tree.findPairOrNull(key) != null;
            }

            @Override
            public V get(K key) {
                KeyValuePair pair = this.tree.findPairOrNull(key);
                AssertStatus.assertNotNull(pair, "not exist for key");
                return pair.getValue();
            }

            @Override
            public V getOrNull(K key) {
                KeyValuePair pair = this.tree.findPairOrNull(key);
                if (pair == null) {
                    return null;
                }
                return pair.getValue();
            }

            @Override
            public void add(K key, V value) {
                InsertionResult res = this.tree.insertOrUpdate(key, value);
                AssertStatus.assertTrue(res == InsertionResult.INSERTED);
                ++this.size;
            }

            @Override
            public void replace(K key, V value) {
                InsertionResult res = this.tree.insertOrUpdate(key, value);
                AssertStatus.assertTrue(res == InsertionResult.UPDATED);
            }

            @Override
            public void addOrReplace(K key, V value) {
                InsertionResult r = this.tree.insertOrUpdate(key, value);
                if (r == InsertionResult.INSERTED) {
                    ++this.size;
                }
            }

            @Override
            public void clear() {
                this.tree.clear();
                this.size = 0;
            }

            @Override
            public boolean isEmpty() {
                return this.size == 0;
            }

            @Override
            public Iterator<KeyValuePair<K, V>> iterator() {
                return this.tree.getInOrderIterator();
            }

            @Override
            public void remove(K key) {
                RemoveResult r = this.tree.removeIfExist(key);
                if (r == RemoveResult.REMOVED) {
                    --this.size;
                }
            }

            @Override
            public int size() {
                return this.size;
            }

            public String toString() {
                return IterableToString.toString(this);
            }
        };
    }

    private MutableSortedMapUsingBinarySearchTree() {
    }
}

