/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.core.value;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaPlugin;
import org.apache.hop.neo4j.core.data.GraphData;
import org.w3c.dom.Node;

@ValueMetaPlugin(id="303", name="Graph", image="graph.svg", description="Graph data type containing nodes, relationships and their properties")
public class ValueMetaGraph
extends ValueMetaBase {
    public static final int TYPE_GRAPH = 303;
    public static final String CONST_UNKNOWN_STORAGE_TYPE = " : Unknown storage type ";
    public static final String CONST_SPECIFIED = " specified.";

    public ValueMetaGraph() {
        super(null, 303);
    }

    public ValueMetaGraph(String name) {
        super(name, 303);
    }

    public ValueMetaGraph(Node node) throws HopException {
        super(node);
    }

    public Object getNativeDataType(Object object) throws HopValueException {
        return this.getGraphData(object);
    }

    public GraphData getGraphData(Object object) throws HopValueException {
        switch (this.type) {
            case 303: {
                switch (this.storageType) {
                    case 0: {
                        break;
                    }
                    default: {
                        throw new HopValueException("Only normal storage type is supported for Graph value : " + this.toString());
                    }
                }
                return (GraphData)object;
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        try {
                            return new GraphData((String)object);
                        }
                        catch (Exception e) {
                            throw new HopValueException("Error converting a JSON representation of Graph value data to a native representation", (Throwable)e);
                        }
                    }
                }
                throw new HopValueException("Only normal storage type is supported for Graph value : " + this.toString());
            }
        }
        throw new HopValueException("Unable to convert data type " + this.toString() + " to Graph value");
    }

    public String getString(Object object) throws HopValueException {
        try {
            String string;
            switch (this.type) {
                case 2: {
                    string = switch (this.storageType) {
                        case 0 -> {
                            if (object == null) {
                                yield null;
                            }
                            yield object.toString();
                        }
                        case 1 -> (String)this.convertBinaryStringToNativeType((byte[])object);
                        case 2 -> {
                            if (object == null) {
                                yield null;
                            }
                            yield (String)this.index[(Integer)object];
                        }
                        default -> throw new HopValueException(this.toString() + CONST_UNKNOWN_STORAGE_TYPE + this.storageType + CONST_SPECIFIED);
                    };
                    if (string == null) break;
                    string = this.trim(string);
                    break;
                }
                case 3: {
                    throw new HopValueException("You can't convert a Date to a Graph data type for : " + this.toString());
                }
                case 1: {
                    throw new HopValueException("You can't convert a Number to a Graph data type for : " + this.toString());
                }
                case 5: {
                    throw new HopValueException("You can't convert an Integer to a Graph data type for : " + this.toString());
                }
                case 6: {
                    throw new HopValueException("You can't convert a BigNumber to a Graph data type for : " + this.toString());
                }
                case 4: {
                    throw new HopValueException("You can't convert a Boolean to a Graph data type for : " + this.toString());
                }
                case 8: {
                    string = switch (this.storageType) {
                        case 0 -> this.convertBinaryStringToString((byte[])object);
                        case 1 -> this.convertBinaryStringToString((byte[])object);
                        case 2 -> {
                            if (object == null) {
                                yield null;
                            }
                            yield this.convertBinaryStringToString((byte[])this.index[(Integer)object]);
                        }
                        default -> throw new HopValueException(this.toString() + CONST_UNKNOWN_STORAGE_TYPE + this.storageType + CONST_SPECIFIED);
                    };
                    break;
                }
                case 7: {
                    string = switch (this.storageType) {
                        case 0 -> {
                            if (object == null) {
                                yield null;
                            }
                            yield object.toString();
                        }
                        case 1 -> this.convertBinaryStringToString((byte[])object);
                        case 2 -> {
                            if (object == null) {
                                yield null;
                            }
                            yield this.index[(Integer)object].toString();
                        }
                        default -> throw new HopValueException(this.toString() + CONST_UNKNOWN_STORAGE_TYPE + this.storageType + CONST_SPECIFIED);
                    };
                    break;
                }
                case 303: {
                    string = switch (this.storageType) {
                        case 0 -> {
                            if (object == null) {
                                yield null;
                            }
                            yield ((GraphData)object).toJsonString();
                        }
                        default -> throw new HopValueException(this.toString() + " : Unsupported storage type " + this.getStorageTypeDesc() + " for " + this.toString());
                    };
                    break;
                }
                default: {
                    throw new HopValueException(this.toString() + " : Unknown type " + this.type + CONST_SPECIFIED);
                }
            }
            if (this.isOutputPaddingEnabled() && this.getLength() > 0) {
                string = ValueDataUtil.rightPad((String)string, (int)this.getLength());
            }
            return string;
        }
        catch (ClassCastException e) {
            throw new HopValueException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + String.valueOf(object) + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
    }

    public Object cloneValueData(Object object) throws HopValueException {
        if (object == null) {
            return null;
        }
        GraphData graphData = this.getGraphData(object);
        return new GraphData(graphData);
    }

    public Class<?> getNativeDataTypeClass() throws HopValueException {
        return GraphData.class;
    }
}

