/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.calculator.calculations.date;

import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.calculator.CalculationInput;
import org.apache.hop.pipeline.transforms.calculator.CalculationOutput;
import org.apache.hop.pipeline.transforms.calculator.ICalculation;

public class DateDiff
implements ICalculation {
    private final String code;
    private final String resultType;
    private final String description;

    public DateDiff(INTERVAL interval) {
        this.code = interval.name();
        this.resultType = interval.resultType;
        this.description = BaseMessages.getString((Class)PKG, (String)interval.messageKey, (String[])new String[0]);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getDefaultResultType() {
        return 5;
    }

    @Override
    public CalculationOutput calculate(CalculationInput in) throws HopValueException {
        return new CalculationOutput(this.getDefaultResultType(), ValueDataUtil.DateDiff((IValueMeta)in.metaA, (Object)in.dataA, (IValueMeta)in.metaB, (Object)in.dataB, (String)this.resultType));
    }

    public static enum INTERVAL {
        DATE_DIFF("d", "CalculatorMetaFunction.CalcFunctions.DateDiff"),
        DATE_DIFF_HR("h", "CalculatorMetaFunction.CalcFunctions.DateDiffHr"),
        DATE_DIFF_MN("mn", "CalculatorMetaFunction.CalcFunctions.DateDiffMn"),
        DATE_DIFF_SEC("s", "CalculatorMetaFunction.CalcFunctions.DateDiffSec"),
        DATE_DIFF_MSEC("ms", "CalculatorMetaFunction.CalcFunctions.DateDiffMsec");

        final String resultType;
        final String messageKey;

        private INTERVAL(String resultType, String messageKey) {
            this.resultType = resultType;
            this.messageKey = messageKey;
        }
    }
}

