/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.IdentityHashMap;
import org.apache.beam.runners.direct.AbstractModelEnforcement;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.ModelEnforcement;
import org.apache.beam.runners.direct.ModelEnforcementFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.IllegalMutationException;
import org.apache.beam.sdk.util.MutationDetector;
import org.apache.beam.sdk.util.MutationDetectors;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ImmutabilityEnforcementFactory
implements ModelEnforcementFactory {
    ImmutabilityEnforcementFactory() {
    }

    public static @UnknownKeyFor @NonNull @Initialized ModelEnforcementFactory create() {
        return new ImmutabilityEnforcementFactory();
    }

    @Override
    public <T> @UnknownKeyFor @NonNull @Initialized ModelEnforcement<T> forBundle(@UnknownKeyFor @NonNull @Initialized CommittedBundle<T> input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> consumer) {
        if (ImmutabilityEnforcementFactory.isReadTransform(consumer)) {
            return NoopReadEnforcement.INSTANCE;
        }
        return new ImmutabilityCheckingEnforcement(input, consumer);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isReadTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> consumer) {
        IsReadVisitor visitor = new IsReadVisitor((PTransform)consumer.getTransform());
        consumer.getPipeline().traverseTopologically(visitor);
        return visitor.isRead();
    }

    private static class ImmutabilityCheckingEnforcement<@UnknownKeyFor T>
    extends AbstractModelEnforcement<T> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform;
        private final @UnknownKeyFor @NonNull @Initialized IdentityHashMap<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>, @UnknownKeyFor @NonNull @Initialized MutationDetector> mutationElements;
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;

        private ImmutabilityCheckingEnforcement(@UnknownKeyFor @NonNull @Initialized CommittedBundle<T> input, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            this.transform = transform;
            this.coder = ((PCollection)input.getPCollection()).getCoder();
            this.mutationElements = new IdentityHashMap();
        }

        @Override
        public void beforeElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> element) {
            try {
                this.mutationElements.put(element, MutationDetectors.forValueWithCoder(element.getValue(), this.coder));
            }
            catch (CoderException e) {
                throw UserCodeException.wrap(e);
            }
        }

        @Override
        public void afterElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> element) {
            this.verifyUnmodified(this.mutationElements.get(element));
        }

        @Override
        public void afterFinish(@UnknownKeyFor @NonNull @Initialized CommittedBundle<T> input, @UnknownKeyFor @NonNull @Initialized TransformResult<T> result, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs) {
            for (MutationDetector detector : this.mutationElements.values()) {
                this.verifyUnmodified(detector);
            }
        }

        private void verifyUnmodified(@UnknownKeyFor @NonNull @Initialized MutationDetector detector) {
            try {
                detector.verifyUnmodified();
            }
            catch (IllegalMutationException e) {
                throw new IllegalMutationException(String.format("PTransform %s illegaly mutated value %s of class %s. Input values must not be mutated in any way.", this.transform.getFullName(), e.getSavedValue(), e.getSavedValue().getClass()), e.getSavedValue(), e.getNewValue());
            }
        }
    }

    private static class NoopReadEnforcement<@UnknownKeyFor T>
    extends AbstractModelEnforcement<T> {
        private static final @UnknownKeyFor @NonNull @Initialized NoopReadEnforcement INSTANCE = new NoopReadEnforcement();

        private NoopReadEnforcement() {
        }
    }

    private static class IsReadVisitor
    extends Pipeline.PipelineVisitor.Defaults {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform;
        private @UnknownKeyFor @NonNull @Initialized boolean isRead;
        private @UnknownKeyFor @NonNull @Initialized boolean isInsideRead;

        private IsReadVisitor(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            this.transform = transform;
        }

        @Override
        public  @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            if (node.getTransform() instanceof Read.Bounded || node.getTransform() instanceof Read.Unbounded) {
                this.isInsideRead = true;
            }
            if (this.isInsideRead && node.getTransform() == this.transform) {
                this.isRead = true;
            }
            return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
        }

        @Override
        public void leaveCompositeTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            if (node.getTransform() instanceof Read.Bounded || node.getTransform() instanceof Read.Unbounded) {
                this.isInsideRead = false;
            }
        }

        @Override
        public void visitPrimitiveTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            if (this.isInsideRead && node.getTransform() == this.transform) {
                this.isRead = true;
            }
        }

        private @UnknownKeyFor @NonNull @Initialized boolean isRead() {
            return this.isRead;
        }
    }
}

