/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum SearchMatchTypeV2 {
    FILENAME,
    FILE_CONTENT,
    FILENAME_AND_CONTENT,
    IMAGE_CONTENT,
    OTHER;


    static class Serializer
    extends UnionSerializer<SearchMatchTypeV2> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SearchMatchTypeV2 value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case FILENAME: {
                    g.writeString("filename");
                    break;
                }
                case FILE_CONTENT: {
                    g.writeString("file_content");
                    break;
                }
                case FILENAME_AND_CONTENT: {
                    g.writeString("filename_and_content");
                    break;
                }
                case IMAGE_CONTENT: {
                    g.writeString("image_content");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public SearchMatchTypeV2 deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            SearchMatchTypeV2 value = "filename".equals(tag) ? FILENAME : ("file_content".equals(tag) ? FILE_CONTENT : ("filename_and_content".equals(tag) ? FILENAME_AND_CONTENT : ("image_content".equals(tag) ? IMAGE_CONTENT : OTHER)));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

