/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.delta;

import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;

class DeltaBinaryPackingConfig {
    final int blockSizeInValues;
    final int miniBlockNumInABlock;
    final int miniBlockSizeInValues;

    public DeltaBinaryPackingConfig(int blockSizeInValues, int miniBlockNumInABlock) {
        this.blockSizeInValues = blockSizeInValues;
        this.miniBlockNumInABlock = miniBlockNumInABlock;
        double miniSize = (double)blockSizeInValues / (double)miniBlockNumInABlock;
        Preconditions.checkArgument((miniSize % 8.0 == 0.0 ? 1 : 0) != 0, (String)"miniBlockSize must be multiple of 8, but it's %s", (Object)miniSize);
        this.miniBlockSizeInValues = (int)miniSize;
    }

    public static DeltaBinaryPackingConfig readConfig(InputStream in) throws IOException {
        return new DeltaBinaryPackingConfig(BytesUtils.readUnsignedVarInt((InputStream)in), BytesUtils.readUnsignedVarInt((InputStream)in));
    }

    public BytesInput toBytesInput() {
        return BytesInput.concat((BytesInput[])new BytesInput[]{BytesInput.fromUnsignedVarInt((int)this.blockSizeInValues), BytesInput.fromUnsignedVarInt((int)this.miniBlockNumInABlock)});
    }
}

