/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.jmx;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.jmx.Handler;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public class ServerMBean
extends Handler.AbstractMBean {
    private final Instant startup = Instant.now();

    public ServerMBean(Object managedObject) {
        super(managedObject);
    }

    @Override
    public Server getManagedObject() {
        return (Server)super.getManagedObject();
    }

    public String getObjectNameBasis() {
        Server server = this.getManagedObject();
        return server.getName();
    }

    public String getObjectContextBasis() {
        Server server = this.getManagedObject();
        String name = server.getName();
        if (name != null) {
            return name;
        }
        return "%s@%x".formatted(TypeUtil.toShortName(server.getClass()), server.hashCode());
    }

    @ManagedAttribute(value="The contexts on this server")
    public List<ContextHandler> getContexts() {
        return this.getManagedObject().getDescendants(ContextHandler.class);
    }

    @ManagedAttribute(value="The UTC startup instant")
    public String getStartupTime() {
        return this.startup.toString();
    }

    @ManagedAttribute(value="The uptime duration in d:HH:mm:ss.SSS")
    public String getUpTime() {
        Duration upTime = Duration.between(this.startup, Instant.now());
        return "%d:%02d:%02d:%02d.%03d".formatted(upTime.toDaysPart(), upTime.toHoursPart(), upTime.toMinutesPart(), upTime.toSecondsPart(), upTime.toMillisPart());
    }
}

