/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.dialog;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class PreviewSelectDialog
extends Dialog {
    private static final Class<?> PKG = PreviewSelectDialog.class;
    private TableView wFields;
    private Shell shell;
    private PipelineMeta pipelineMeta;
    public String[] previewTransforms;
    public int[] previewSizes;
    private PropsUi props;

    public PreviewSelectDialog(Shell parent, int style, PipelineMeta pipelineMeta) {
        super(parent, style);
        this.pipelineMeta = pipelineMeta;
        this.props = PropsUi.getInstance();
        this.previewTransforms = null;
        this.previewSizes = null;
    }

    public void open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PreviewSelectDialog.Dialog.PreviewSelection.Title", (String[])new String[0]));
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        int margin = PropsUi.getMargin();
        Button wPreview = new Button((Composite)this.shell, 8);
        wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Show", (String[])new String[0]));
        wPreview.addListener(13, e -> this.preview());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wPreview, wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"PreviewSelectDialog.Label.Transforms", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, margin);
        wlFields.setLayoutData((Object)fdlFields);
        List usedTransforms = this.pipelineMeta.getUsedTransforms();
        int nrRows = usedTransforms.size();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PreviewSelectDialog.Column.TransformName", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PreviewSelectDialog.Column.PreviewSize", (String[])new String[0]), 1, false, false)};
        this.wFields = new TableView(HopGui.getInstance().getVariables(), (Composite)this.shell, 67586, columns, nrRows, true, null, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)wPreview, -2 * margin);
        this.wFields.setLayoutData(fdFields);
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.preview(), c -> this.cancel());
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        String[] prTransforms = this.props.getLastPreview();
        int[] prSizes = this.props.getLastPreviewSize();
        List selectedTransforms = this.pipelineMeta.getSelectedTransforms();
        List usedTransforms = this.pipelineMeta.getUsedTransforms();
        if (selectedTransforms.isEmpty()) {
            int line = 0;
            for (TransformMeta transformMeta : usedTransforms) {
                TableItem item = this.wFields.table.getItem(line++);
                String name = transformMeta.getName();
                item.setText(1, transformMeta.getName());
                item.setText(2, "0");
                for (int x = 0; x < prTransforms.length; ++x) {
                    if (!prTransforms[x].equalsIgnoreCase(name)) continue;
                    item.setText(2, "" + prSizes[x]);
                }
            }
        } else {
            int line = 0;
            for (TransformMeta transformMeta : usedTransforms) {
                TableItem item = this.wFields.table.getItem(line++);
                String name = transformMeta.getName();
                item.setText(1, transformMeta.getName());
                item.setText(2, "");
                if (!transformMeta.isSelected()) continue;
                item.setText(2, "" + this.props.getDefaultPreviewSize());
            }
        }
        this.wFields.optWidth(true);
    }

    private void cancel() {
        this.dispose();
    }

    private void preview() {
        int size;
        TableItem ti;
        int i;
        int sels = 0;
        for (i = 0; i < this.wFields.table.getItemCount(); ++i) {
            ti = this.wFields.table.getItem(i);
            size = Const.toInt((String)ti.getText(2), (int)0);
            if (size <= 0) continue;
            ++sels;
        }
        this.previewTransforms = new String[sels];
        this.previewSizes = new int[sels];
        sels = 0;
        for (i = 0; i < this.wFields.table.getItemCount(); ++i) {
            ti = this.wFields.table.getItem(i);
            size = Const.toInt((String)ti.getText(2), (int)0);
            if (size <= 0) continue;
            this.previewTransforms[sels] = ti.getText(1);
            this.previewSizes[sels] = size;
            ++sels;
        }
        this.props.setLastPreview(this.previewTransforms, this.previewSizes);
        this.dispose();
    }
}

