/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCPooledConnection;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ToolboxWrapper;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.ConnectionEvent;

public class AS400JDBCConnectionHandle
extends ToolboxWrapper
implements Connection {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCPooledConnection pooledConnection_ = null;
    private AS400JDBCConnection connection_ = null;

    AS400JDBCConnectionHandle(AS400JDBCPooledConnection pooledConnection, AS400JDBCConnection connection) {
        if (pooledConnection == null) {
            throw new NullPointerException("pooledConnection");
        }
        this.pooledConnection_ = pooledConnection;
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection_ = connection;
    }

    void invalidate() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "invalidate()");
        }
        this.connection_ = null;
        this.pooledConnection_ = null;
    }

    void checkAccess(JDSQLStatement sqlStatement) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.checkAccess(sqlStatement);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    void checkOpen() throws SQLException {
        this.validateConnection();
        try {
            this.connection_.checkOpen();
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.validateConnection();
        this.connection_.clearWarnings();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "close()");
        }
        if (this.connection_ == null) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "close() returning because connection_ is null");
            }
            return;
        }
        try {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "close() calling connection_.pseudoClosed " + this.connection_.getServerJobIdentifier());
            }
            this.connection_.pseudoClose();
        }
        catch (SQLException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "close() calling fireEventIfErrorFatal");
            }
            this.fireEventIfErrorFatal(e);
            throw e;
        }
        finally {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "close() calling pooledConnection_.fireConnectionCloseEvent ");
            }
            this.pooledConnection_.fireConnectionCloseEvent(new ConnectionEvent(this.pooledConnection_));
            this.connection_ = null;
            this.pooledConnection_ = null;
        }
    }

    @Override
    public void commit() throws SQLException {
        this.validateConnection();
        try {
            this.connection_.commit();
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.validateConnection();
        return this.connection_.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateConnection();
        return this.connection_.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateConnection();
        return this.connection_.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected void finalize() throws Throwable {
        block2: {
            try {
                this.close();
            }
            catch (SQLException e) {
                if (!JDTrace.isTraceOn()) break block2;
                JDTrace.logInformation(this, "Finalize on a connection handle threw exception: " + e.getMessage());
            }
        }
    }

    private final void fireEventIfErrorFatal(SQLException e) {
        String sqlState = e.getSQLState();
        if (sqlState.equals("42505") || sqlState.equals("08003") || sqlState.equals("08004") || sqlState.equals("08001") || sqlState.equals("08S01") || sqlState.equals("HY000") || sqlState.equals("HY001") || sqlState.equals("42705")) {
            this.pooledConnection_.fatalConnectionErrorOccurred_ = true;
            this.pooledConnection_.fireConnectionErrorEvent(new ConnectionEvent(this.pooledConnection_, e));
        }
    }

    AS400Impl getAS400() throws SQLException {
        this.validateConnection();
        return this.connection_.getAS400();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.validateConnection();
        return this.connection_.getAutoCommit();
    }

    public int getConcurrentAccessResolution() throws SQLException {
        this.validateConnection();
        return this.connection_.getConcurrentAccessResolution();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.validateConnection();
        return this.connection_.getCatalog();
    }

    ConvTable getConverter() throws SQLException {
        this.validateConnection();
        return this.connection_.getConverter();
    }

    ConvTable getConverter(int ccsid) throws SQLException {
        this.validateConnection();
        return this.connection_.getConverter(ccsid);
    }

    String getDefaultSchema() throws SQLException {
        this.validateConnection();
        return this.connection_.getDefaultSchema();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.validateConnection();
        return this.connection_.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.validateConnection();
        return this.connection_.getMetaData();
    }

    JDProperties getProperties() throws SQLException {
        this.validateConnection();
        return this.connection_.getProperties();
    }

    public String getServerJobIdentifier() throws SQLException {
        this.validateConnection();
        return this.connection_.getServerJobIdentifier();
    }

    public AS400 getSystem() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Warning: returning pooled connection's AS400 object directly to user.");
        }
        return this.connection_.getSystem();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.validateConnection();
        return this.connection_.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.validateConnection();
        return this.connection_.getTypeMap();
    }

    String getURL() throws SQLException {
        this.validateConnection();
        return this.connection_.getURL();
    }

    String getUserName() throws SQLException {
        this.validateConnection();
        return this.connection_.getUserName();
    }

    int getVRM() throws SQLException {
        this.validateConnection();
        return this.connection_.getVRM();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.validateConnection();
        return this.connection_.getWarnings();
    }

    boolean isCursorNameUsed(String cursorName) throws SQLException {
        this.validateConnection();
        return this.connection_.isCursorNameUsed(cursorName);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection_ == null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.validateConnection();
        return this.connection_.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.validateConnection();
        return this.connection_.nativeSQL(sql);
    }

    void notifyClose(AS400JDBCStatement statement, int id) throws SQLException {
        this.validateConnection();
        this.connection_.notifyClose(statement, id);
    }

    void postWarning(int id, int errorCode, int returnCode) throws SQLException {
        this.validateConnection();
        this.connection_.postWarning(id, errorCode, returnCode);
    }

    void postWarningSQLState(String sqlState) throws SQLException {
        this.validateConnection();
        this.connection_.postWarningSQLState(sqlState);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(sql, columnNames);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.validateConnection();
        try {
            this.connection_.rollback();
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.rollback(savepoint);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    void send(DBBaseRequestDS request) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.send(request);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    void send(DBBaseRequestDS request, int id) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.send(request, id);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    void send(DBBaseRequestDS request, int id, boolean leavePending) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.send(request, id, leavePending);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    DBReplyRequestedDS sendAndReceive(DBBaseRequestDS request) throws SQLException {
        this.validateConnection();
        try {
            return this.connection_.sendAndReceive(request);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    DBReplyRequestedDS sendAndReceive(DBBaseRequestDS request, int id) throws SQLException {
        this.validateConnection();
        try {
            return this.connection_.sendAndReceive(request, id);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    public void setConcurrentAccessResolution(int concurrentAccessResolution) throws SQLException {
        this.validateConnection();
        this.connection_.setConcurrentAccessResolution(concurrentAccessResolution);
    }

    public void setDB2eWLMCorrelator(byte[] bytes) throws SQLException {
        this.validateConnection();
        this.connection_.setDB2eWLMCorrelator(bytes);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.validateConnection();
        this.connection_.setCatalog(catalog);
    }

    void setDRDA(boolean drda) throws SQLException {
        this.validateConnection();
        this.connection_.setDRDA(drda);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.validateConnection();
        this.connection_.setHoldability(holdability);
    }

    void setProperties(JDDataSourceURL dataSourceUrl, JDProperties properties, AS400 as400) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.setProperties(dataSourceUrl, properties, as400);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    void setProperties(JDDataSourceURL dataSourceUrl, JDProperties properties, AS400Impl as400) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.setProperties(dataSourceUrl, properties, as400);
        }
        catch (SQLException e) {
            this.fireEventIfErrorFatal(e);
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.validateConnection();
        this.connection_.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.validateConnection();
        return this.connection_.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.validateConnection();
        return this.connection_.setSavepoint(name);
    }

    void setSystem(AS400 as400) throws SQLException {
        this.validateConnection();
        this.connection_.setSystem(as400);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.validateConnection();
        this.connection_.setTransactionIsolation(level);
    }

    public void setTypeMap(Map typeMap) throws SQLException {
        this.validateConnection();
        this.connection_.setTypeMap(typeMap);
    }

    public String toString() {
        if (this.connection_ != null) {
            return this.connection_.toString();
        }
        return super.toString();
    }

    boolean useExtendedFormats() throws SQLException {
        this.validateConnection();
        return this.connection_.useExtendedFormats();
    }

    private void validateConnection() throws SQLException {
        if (this.connection_ == null) {
            JDTrace.logInformation(this, "The connection is closed.");
            JDError.throwSQLException("08003");
        }
    }

    @Override
    protected String[] getValidWrappedList() {
        return new String[]{"java.sql.Connection"};
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.validateConnection();
        return this.connection_.isValid(timeout);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.validateConnection();
        }
        catch (SQLException e) {
            SQLClientInfoException clientIE = new SQLClientInfoException(e.getMessage(), e.getSQLState(), null);
            throw clientIE;
        }
        this.connection_.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.validateConnection();
        return this.connection_.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.validateConnection();
        return this.connection_.getClientInfo();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.validateConnection();
        return this.connection_.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.validateConnection();
        return this.connection_.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.validateConnection();
        return this.connection_.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.validateConnection();
        return this.connection_.createSQLXML();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.validateConnection();
        return this.connection_.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.validateConnection();
        return this.connection_.createStruct(typeName, attributes);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.validateConnection();
        }
        catch (SQLException e) {
            SQLClientInfoException clientIE = new SQLClientInfoException(e.getMessage(), e.getSQLState(), null);
            throw clientIE;
        }
        this.connection_.setClientInfo(name, value);
    }

    public void setDBHostServerTrace(boolean trace) throws SQLException {
        try {
            this.validateConnection();
        }
        catch (SQLException e) {
            SQLClientInfoException clientIE = new SQLClientInfoException(e.getMessage(), e.getSQLState(), null);
            throw clientIE;
        }
        this.connection_.setDBHostServerTrace(trace);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.validateConnection();
        this.connection_.abort(executor);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.validateConnection();
        return this.connection_.getNetworkTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        this.validateConnection();
        return this.connection_.getSchema();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.validateConnection();
        this.connection_.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.validateConnection();
        this.connection_.setSchema(schema);
    }
}

