/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.DynamicEnumClass;
import net.openhft.chronicle.core.pool.StaticEnumClass;
import net.openhft.chronicle.core.util.CoreDynamicEnum;

public abstract class EnumCache<E> {
    private static final ClassLocal<EnumCache> ENUM_CACHE_CL = ClassLocal.withInitial(eClass -> CoreDynamicEnum.class.isAssignableFrom((Class<?>)eClass) ? new DynamicEnumClass(eClass) : new StaticEnumClass(eClass));
    protected final Class<E> type;

    protected EnumCache(Class<E> type) {
        this.type = type;
    }

    public static <E> EnumCache<E> of(Class<E> eClass) {
        return (EnumCache)ENUM_CACHE_CL.get(eClass);
    }

    @Deprecated
    protected static long guessInitialSize(Class<? extends Enum> eClass) {
        Enum[] enumConstants = eClass.getEnumConstants();
        int initialSize = Maths.nextPower2(enumConstants.length * 2, 16);
        int max = 3;
        for (int i = 0; i < 3; ++i) {
            Enum[] cache = new Enum[initialSize];
            int conflicts = 0;
            for (Enum enumConstant : enumConstants) {
                int n = Maths.hash32(enumConstant.name()) & initialSize - 1;
                if (cache[n] == null) {
                    cache[n] = enumConstant;
                    continue;
                }
                ++conflicts;
            }
            if (conflicts <= 0) continue;
            String msg = "EnumCache " + initialSize + " conflicts " + conflicts;
            if (i < 2) {
                Jvm.debug().on(eClass, msg);
                initialSize *= 2;
                continue;
            }
            Jvm.warn().on(eClass, msg);
        }
        return ((long)enumConstants.length << 32) + (long)initialSize;
    }

    public E get(String name) {
        return this.valueOf(name);
    }

    public abstract E valueOf(String var1);

    public abstract int size();

    public Class<?> type() {
        return this.type;
    }

    public abstract E forIndex(int var1);

    public abstract E[] asArray();
}

