/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.FileOrFolderLogInfo;
import com.dropbox.core.v2.teamlog.PathLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileLogInfo
extends FileOrFolderLogInfo {
    public FileLogInfo(@Nonnull PathLogInfo path, @Nullable String displayName, @Nullable String fileId, @Nullable Long fileSize) {
        super(path, displayName, fileId, fileSize);
    }

    public FileLogInfo(@Nonnull PathLogInfo path) {
        this(path, null, null, null);
    }

    @Override
    @Nonnull
    public PathLogInfo getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Nullable
    public String getFileId() {
        return this.fileId;
    }

    @Override
    @Nullable
    public Long getFileSize() {
        return this.fileSize;
    }

    public static Builder newBuilder(PathLogInfo path) {
        return new Builder(path);
    }

    @Override
    public int hashCode() {
        return this.getClass().toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileLogInfo other = (FileLogInfo)obj;
            return (this.path == other.path || this.path.equals(other.path)) && (this.displayName == other.displayName || this.displayName != null && this.displayName.equals(other.displayName)) && (this.fileId == other.fileId || this.fileId != null && this.fileId.equals(other.fileId)) && (this.fileSize == other.fileSize || this.fileSize != null && this.fileSize.equals(other.fileSize));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileLogInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            PathLogInfo.Serializer.INSTANCE.serialize(value.path, g);
            if (value.displayName != null) {
                g.writeFieldName("display_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.displayName, g);
            }
            if (value.fileId != null) {
                g.writeFieldName("file_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.fileId, g);
            }
            if (value.fileSize != null) {
                g.writeFieldName("file_size");
                StoneSerializers.nullable(StoneSerializers.uInt64()).serialize(value.fileSize, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_fileSize;
            String f_fileId;
            String f_displayName;
            PathLogInfo f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_displayName = null;
                f_fileId = null;
                f_fileSize = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = (PathLogInfo)PathLogInfo.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("display_name".equals(field)) {
                        f_displayName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("file_id".equals(field)) {
                        f_fileId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("file_size".equals(field)) {
                        f_fileSize = StoneSerializers.nullable(StoneSerializers.uInt64()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileLogInfo value = new FileLogInfo(f_path, f_displayName, f_fileId, f_fileSize);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends FileOrFolderLogInfo.Builder {
        protected Builder(PathLogInfo path) {
            super(path);
        }

        @Override
        public Builder withDisplayName(String displayName) {
            super.withDisplayName(displayName);
            return this;
        }

        @Override
        public Builder withFileId(String fileId) {
            super.withFileId(fileId);
            return this;
        }

        @Override
        public Builder withFileSize(Long fileSize) {
            super.withFileSize(fileSize);
            return this;
        }

        @Override
        public FileLogInfo build() {
            return new FileLogInfo(this.path, this.displayName, this.fileId, this.fileSize);
        }
    }
}

