/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.CommittedResult;
import org.apache.beam.runners.direct.DirectWriteViewVisitor;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.PCollectionViewWriter;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ViewEvaluatorFactory
implements TransformEvaluatorFactory {
    private final @UnknownKeyFor @NonNull @Initialized EvaluationContext context;

    ViewEvaluatorFactory(@UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
        this.context = context;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<T> forApplication(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputBundle) {
        TransformEvaluator evaluator = this.createEvaluator(application);
        return evaluator;
    }

    @Override
    public void cleanup() throws @UnknownKeyFor @NonNull @Initialized Exception {
    }

    private <InT, OuT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<@UnknownKeyFor @NonNull @Initialized Iterable<InT>> createEvaluator(final @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Iterable<InT>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Iterable<InT>>, @UnknownKeyFor @NonNull @Initialized DirectWriteViewVisitor.WriteView<InT, OuT>> application) {
        PCollection input = (PCollection)Iterables.getOnlyElement(application.getInputs().values());
        final PCollectionViewWriter writer = this.context.createPCollectionViewWriter(input, application.getTransform().getView());
        return new TransformEvaluator<Iterable<InT>>(){
            private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>> elements = new ArrayList();

            @Override
            public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized Iterable<InT>> element) {
                for (Object input : element.getValue()) {
                    this.elements.add(element.withValue(input));
                }
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized TransformResult<@UnknownKeyFor @NonNull @Initialized Iterable<InT>> finishBundle() {
                writer.add(this.elements);
                StepTransformResult.Builder resultBuilder = StepTransformResult.withoutHold(application);
                if (!this.elements.isEmpty()) {
                    resultBuilder = resultBuilder.withAdditionalOutput(CommittedResult.OutputType.PCOLLECTION_VIEW);
                }
                return resultBuilder.build();
            }
        };
    }
}

