/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.googlesheets;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.google.auth.http.HttpCredentialsAdapter;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsCredentials;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsInputData;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsInputField;
import org.apache.hop.pipeline.transforms.googlesheets.GoogleSheetsInputMeta;

public class GoogleSheetsInput
extends BaseTransform<GoogleSheetsInputMeta, GoogleSheetsInputData> {
    public static final String CONST_IN_SPREADSHEET = " in spreadsheet :";

    public GoogleSheetsInput(TransformMeta transformMeta, GoogleSheetsInputMeta meta, GoogleSheetsInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        List transform = this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta());
        ((GoogleSheetsInputData)this.data).hasInput = transform != null && !transform.isEmpty();
        JacksonFactory jsonFactory = null;
        NetHttpTransport httpTransport = null;
        String scope = "https://www.googleapis.com/auth/spreadsheets.readonly";
        try {
            jsonFactory = JacksonFactory.getDefaultInstance();
            httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (Exception e) {
            this.logError("cannot initiate HTTP transport" + e.getMessage());
            return false;
        }
        if (super.init()) {
            try {
                HttpCredentialsAdapter credential = GoogleSheetsCredentials.getCredentialsJson(scope, this.resolve(((GoogleSheetsInputMeta)this.meta).getJsonCredentialPath()), this.resolve(((GoogleSheetsInputMeta)this.meta).getImpersonation()), this.variables);
                Sheets service = new Sheets.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, GoogleSheetsCredentials.setHttpTimeout((HttpRequestInitializer)credential, this.resolve(((GoogleSheetsInputMeta)this.meta).getTimeout()))).setApplicationName("Apache-Hop-Google-Sheets").build();
                String range = this.resolve(((GoogleSheetsInputMeta)this.meta).getWorksheetId());
                ValueRange response = (ValueRange)service.spreadsheets().values().get(this.resolve(((GoogleSheetsInputMeta)this.meta).getSpreadsheetKey()), range).execute();
                if (response == null) {
                    this.logError("No data found for worksheet : " + this.resolve(((GoogleSheetsInputMeta)this.meta).getWorksheetId()) + CONST_IN_SPREADSHEET + this.resolve(((GoogleSheetsInputMeta)this.meta).getSpreadsheetKey()));
                    return false;
                }
                List values = response.getValues();
                this.logBasic("Reading Sheet, found: " + values.size() + " rows");
                if (values == null || values.isEmpty()) {
                    throw new HopTransformException("No response found for worksheet : " + this.resolve(((GoogleSheetsInputMeta)this.meta).getWorksheetId()) + CONST_IN_SPREADSHEET + this.resolve(((GoogleSheetsInputMeta)this.meta).getSpreadsheetKey()));
                }
                ((GoogleSheetsInputData)this.data).rows = values;
            }
            catch (Exception e) {
                this.logError("Error: for worksheet : " + this.resolve(((GoogleSheetsInputMeta)this.meta).getWorksheetId()) + CONST_IN_SPREADSHEET + this.resolve(((GoogleSheetsInputMeta)this.meta).getSpreadsheetKey()) + e.getMessage(), e);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean processRow() throws HopException {
        if (this.first) {
            this.first = false;
            ((GoogleSheetsInputData)this.data).outputRowMeta = new RowMeta();
            ((GoogleSheetsInputMeta)this.meta).getFields(((GoogleSheetsInputData)this.data).outputRowMeta, this.getTransformName(), null, this.getTransformMeta(), (IVariables)this, this.metadataProvider);
            ++((GoogleSheetsInputData)this.data).currentRow;
        } else {
            try {
                Object[] outputRowData = this.readRow();
                if (outputRowData == null) {
                    this.setOutputDone();
                    boolean bl = false;
                    return bl;
                }
                this.putRow(((GoogleSheetsInputData)this.data).outputRowMeta, outputRowData);
            }
            catch (Exception e) {
                throw new HopException(e.getMessage());
            }
            finally {
                ++((GoogleSheetsInputData)this.data).currentRow;
            }
        }
        return true;
    }

    private Object getRowDataValue(IValueMeta targetValueMeta, IValueMeta sourceValueMeta, Object value, DateFormat df) throws HopException {
        if (value == null) {
            return null;
        }
        if (2 == targetValueMeta.getType()) {
            return targetValueMeta.convertData(sourceValueMeta, (Object)value.toString());
        }
        if (1 == targetValueMeta.getType()) {
            return targetValueMeta.convertData(sourceValueMeta, (Object)Double.valueOf(value.toString()));
        }
        if (5 == targetValueMeta.getType()) {
            return targetValueMeta.convertData(sourceValueMeta, (Object)Long.valueOf(value.toString()));
        }
        if (6 == targetValueMeta.getType()) {
            return targetValueMeta.convertData(sourceValueMeta, (Object)new BigDecimal(value.toString()));
        }
        if (4 == targetValueMeta.getType()) {
            return targetValueMeta.convertData(sourceValueMeta, (Object)Boolean.valueOf(value.toString()));
        }
        if (8 == targetValueMeta.getType()) {
            return targetValueMeta.convertData(sourceValueMeta, value);
        }
        if (3 == targetValueMeta.getType()) {
            try {
                return targetValueMeta.convertData(sourceValueMeta, (Object)df.parse(value.toString()));
            }
            catch (ParseException e) {
                throw new HopValueException("Unable to convert data type of value");
            }
        }
        throw new HopValueException("Unable to convert data type of value");
    }

    private Object[] readRow() {
        try {
            this.logRowlevel("Allocating :" + Integer.toString(((GoogleSheetsInputData)this.data).outputRowMeta.size()));
            Object[] outputRowData = RowDataUtil.allocateRowData((int)((GoogleSheetsInputData)this.data).outputRowMeta.size());
            int outputIndex = 0;
            this.logRowlevel("Reading Row: " + Integer.toString(((GoogleSheetsInputData)this.data).currentRow) + " out of : " + Integer.toString(((GoogleSheetsInputData)this.data).rows.size()));
            if (((GoogleSheetsInputData)this.data).currentRow < ((GoogleSheetsInputData)this.data).rows.size()) {
                List<Object> row = ((GoogleSheetsInputData)this.data).rows.get(((GoogleSheetsInputData)this.data).currentRow);
                for (IValueMeta column : ((GoogleSheetsInputData)this.data).outputRowMeta.getValueMetaList()) {
                    Object value = null;
                    this.logRowlevel("Reading columns: " + Integer.toString(outputIndex) + " out of : " + Integer.toString(row.size()));
                    if (outputIndex > row.size() - 1) {
                        this.logRowlevel("Beyond size");
                        outputRowData[outputIndex++] = null;
                        continue;
                    }
                    if (row.get(outputIndex) != null) {
                        this.logRowlevel("getting value" + outputIndex);
                        value = row.get(outputIndex);
                        this.logRowlevel("got value " + outputIndex);
                    }
                    if (value == null || value.toString().isEmpty()) {
                        outputRowData[outputIndex++] = null;
                        this.logRowlevel("null value");
                        continue;
                    }
                    GoogleSheetsInputField input = ((GoogleSheetsInputMeta)this.meta).getInputFields().get(outputIndex);
                    SimpleDateFormat df = column.getType() == 3 ? new SimpleDateFormat(input.getFormat()) : null;
                    outputRowData[outputIndex++] = this.getRowDataValue(column, column, value, df);
                    this.logRowlevel("value : " + value.toString());
                }
            } else {
                this.logBasic("Finished reading last row " + Integer.toString(((GoogleSheetsInputData)this.data).currentRow) + " / " + Integer.toString(((GoogleSheetsInputData)this.data).rows.size()));
                return null;
            }
            return outputRowData;
        }
        catch (Exception e) {
            this.logError("Exception reading value :" + e.getMessage());
            return null;
        }
    }
}

