/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.querybuilder.schema;

import com.datastax.dse.driver.api.querybuilder.schema.CreateDseAggregateEnd;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseAggregateStart;
import com.datastax.dse.driver.api.querybuilder.schema.CreateDseAggregateStateFunc;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultCreateDseAggregate
implements CreateDseAggregateEnd,
CreateDseAggregateStart,
CreateDseAggregateStateFunc {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier functionName;
    private boolean orReplace;
    private boolean ifNotExists;
    private final ImmutableList<DataType> parameters;
    private final CqlIdentifier sFunc;
    private final DataType sType;
    private final CqlIdentifier finalFunc;
    private final Term term;
    private final boolean deterministic;

    public DefaultCreateDseAggregate(@NonNull CqlIdentifier functionName) {
        this(null, functionName);
    }

    public DefaultCreateDseAggregate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier functionName) {
        this(keyspace, functionName, false, false, (ImmutableList<DataType>)ImmutableList.of(), null, null, null, null, false);
    }

    public DefaultCreateDseAggregate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier functionName, boolean orReplace, boolean ifNotExists, @NonNull ImmutableList<DataType> parameters, @Nullable CqlIdentifier sFunc, @Nullable DataType sType, @Nullable CqlIdentifier finalFunc, @Nullable Term term, boolean deterministic) {
        this.keyspace = keyspace;
        this.functionName = functionName;
        this.orReplace = orReplace;
        this.ifNotExists = ifNotExists;
        this.parameters = parameters;
        this.sFunc = sFunc;
        this.sType = sType;
        this.finalFunc = finalFunc;
        this.term = term;
        this.deterministic = deterministic;
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE ");
        if (this.orReplace) {
            builder.append("OR REPLACE ");
        }
        builder.append("AGGREGATE ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        CqlHelper.qualify(this.keyspace, this.functionName, builder);
        builder.append(" (");
        boolean first = true;
        for (DataType param : this.parameters) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(param.asCql(false, true));
        }
        builder.append(')');
        if (this.sFunc != null) {
            builder.append(" SFUNC ");
            builder.append(this.sFunc.asCql(true));
        }
        if (this.sType != null) {
            builder.append(" STYPE ");
            builder.append(this.sType.asCql(false, true));
        }
        if (this.finalFunc != null) {
            builder.append(" FINALFUNC ");
            builder.append(this.finalFunc.asCql(true));
        }
        if (this.term != null) {
            builder.append(" INITCOND ");
            this.term.appendTo(builder);
        }
        if (this.deterministic) {
            builder.append(" DETERMINISTIC");
        }
        return builder.toString();
    }

    @Override
    @NonNull
    public CreateDseAggregateEnd withInitCond(@NonNull Term term) {
        return new DefaultCreateDseAggregate(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.sFunc, this.sType, this.finalFunc, term, this.deterministic);
    }

    @Override
    @NonNull
    public CreateDseAggregateStart ifNotExists() {
        return new DefaultCreateDseAggregate(this.keyspace, this.functionName, this.orReplace, true, this.parameters, this.sFunc, this.sType, this.finalFunc, this.term, this.deterministic);
    }

    @Override
    @NonNull
    public CreateDseAggregateStart orReplace() {
        return new DefaultCreateDseAggregate(this.keyspace, this.functionName, true, this.ifNotExists, this.parameters, this.sFunc, this.sType, this.finalFunc, this.term, this.deterministic);
    }

    @Override
    @NonNull
    public CreateDseAggregateStart withParameter(@NonNull DataType paramType) {
        return new DefaultCreateDseAggregate(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, ImmutableCollections.append(this.parameters, paramType), this.sFunc, this.sType, this.finalFunc, this.term, this.deterministic);
    }

    @Override
    @NonNull
    public CreateDseAggregateStateFunc withSFunc(@NonNull CqlIdentifier sFunc) {
        return new DefaultCreateDseAggregate(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, sFunc, this.sType, this.finalFunc, this.term, this.deterministic);
    }

    @Override
    @NonNull
    public CreateDseAggregateEnd withSType(@NonNull DataType sType) {
        return new DefaultCreateDseAggregate(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.sFunc, sType, this.finalFunc, this.term, this.deterministic);
    }

    @Override
    @NonNull
    public CreateDseAggregateEnd withFinalFunc(@NonNull CqlIdentifier finalFunc) {
        return new DefaultCreateDseAggregate(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.sFunc, this.sType, finalFunc, this.term, this.deterministic);
    }

    @Override
    @NonNull
    public CreateDseAggregateEnd deterministic() {
        return new DefaultCreateDseAggregate(this.keyspace, this.functionName, this.orReplace, this.ifNotExists, this.parameters, this.sFunc, this.sType, this.finalFunc, this.term, true);
    }

    public String toString() {
        return this.asCql();
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getFunctionName() {
        return this.functionName;
    }

    public boolean isOrReplace() {
        return this.orReplace;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @NonNull
    public ImmutableList<DataType> getParameters() {
        return this.parameters;
    }

    @Nullable
    public CqlIdentifier getsFunc() {
        return this.sFunc;
    }

    @Nullable
    public DataType getsType() {
        return this.sType;
    }

    @Nullable
    public CqlIdentifier getFinalFunc() {
        return this.finalFunc;
    }

    @Nullable
    public Term getTerm() {
        return this.term;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }
}

