/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter;

import io.confluent.kafka.formatter.SchemaMessageReader;
import io.confluent.kafka.formatter.SchemaMessageSerializer;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import io.confluent.kafka.serializers.KafkaAvroSerializerConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class AvroMessageReader
extends SchemaMessageReader<Object> {
    private final DecoderFactory decoderFactory = DecoderFactory.get();

    public AvroMessageReader() {
    }

    AvroMessageReader(String url, Schema keySchema, Schema valueSchema, String topic, boolean parseKey, BufferedReader reader, boolean normalizeSchema, boolean autoRegister, boolean useLatest) {
        super(url, (ParsedSchema)new AvroSchema(keySchema), (ParsedSchema)new AvroSchema(valueSchema), topic, parseKey, reader, normalizeSchema, autoRegister, useLatest);
    }

    protected SchemaMessageSerializer<Object> createSerializer(Serializer keySerializer) {
        return new AvroMessageSerializer(keySerializer);
    }

    protected SchemaProvider getProvider() {
        return new AvroSchemaProvider();
    }

    protected Object readFrom(String jsonString, ParsedSchema parsedSchema) {
        Schema schema = ((AvroSchema)parsedSchema).rawSchema();
        try {
            Object object = AvroSchemaUtils.toObject((String)jsonString, (AvroSchema)((AvroSchema)parsedSchema));
            if (schema.getType().equals((Object)Schema.Type.STRING)) {
                object = ((Utf8)object).toString();
            }
            return object;
        }
        catch (IOException e) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)e);
        }
        catch (AvroRuntimeException e) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)e);
        }
    }

    static class AvroMessageSerializer
    extends AbstractKafkaAvroSerializer
    implements SchemaMessageSerializer<Object> {
        protected final Serializer keySerializer;

        AvroMessageSerializer(Serializer keySerializer) {
            this.keySerializer = keySerializer;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.configure(new KafkaAvroSerializerConfig(configs));
        }

        public Serializer getKeySerializer() {
            return this.keySerializer;
        }

        public byte[] serializeKey(String topic, Headers headers, Object payload) {
            return this.keySerializer.serialize(topic, headers, payload);
        }

        public byte[] serialize(String subject, String topic, boolean isKey, Headers headers, Object object, ParsedSchema schema) {
            return super.serializeImpl(subject, topic, headers, object, (AvroSchema)schema);
        }

        public SchemaRegistryClient getSchemaRegistryClient() {
            return this.schemaRegistry;
        }

        public void close() throws IOException {
            if (this.keySerializer != null) {
                this.keySerializer.close();
            }
            super.close();
        }
    }
}

