/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer.config;

import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.explorer.config.ExplorerPerspectiveConfig;
import org.apache.hop.ui.hopgui.perspective.explorer.config.ExplorerPerspectiveConfigSingleton;
import org.eclipse.swt.widgets.Control;
import picocli.CommandLine;

@ConfigPlugin(id="ExplorerPerspectiveConfigPlugin", description="Configuration options for the explorer perspective", category="config")
@GuiPlugin(description="Explorer Perspective")
public class ExplorerPerspectiveConfigPlugin
implements IConfigOptions,
IGuiPluginCompositeWidgetsListener {
    private static final String WIDGET_ID_LAZY_LOADING_DEPTH = "10000-lazy-loading-depth";
    private static final String WIDGET_ID_FILE_LOADING_MAX_SIZE = "10100-file-loading-max-size";
    @GuiWidgetElement(id="10000-lazy-loading-depth", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::ExplorerPerspectiveConfig.LazyLoading.Label", toolTip="i18n::ExplorerPerspectiveConfig.LazyLoading.Tooltip")
    @CommandLine.Option(names={"-exid", "--explorer-lazy-loading-initial-depth"}, description={"For the explorer perspective: the initial depth to load not lazily"})
    private String lazyLoadingDepth;
    @GuiWidgetElement(id="10100-file-loading-max-size", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::ExplorerPerspectiveConfig.FileSize.Label", toolTip="i18n::ExplorerPerspectiveConfig.FileSize.Tooltip")
    @CommandLine.Option(names={"-exms", "--explorer-file-loading-max-size"}, description={"For the explorer: the maximum file size to load"})
    private String fileLoadingMaxSize;

    public static ExplorerPerspectiveConfigPlugin getInstance() {
        ExplorerPerspectiveConfigPlugin instance = new ExplorerPerspectiveConfigPlugin();
        ExplorerPerspectiveConfig config = ExplorerPerspectiveConfigSingleton.getConfig();
        instance.lazyLoadingDepth = config.getLazyLoadingDepth();
        instance.fileLoadingMaxSize = config.getFileLoadingMaxSize();
        return instance;
    }

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        ExplorerPerspectiveConfig config = ExplorerPerspectiveConfigSingleton.getConfig();
        try {
            boolean changed = false;
            if (this.lazyLoadingDepth != null) {
                config.setLazyLoadingDepth(this.lazyLoadingDepth);
                log.logBasic("Explorer perspective: the lazy loading depth is set to '" + this.lazyLoadingDepth + "'");
                changed = true;
            }
            if (this.fileLoadingMaxSize != null) {
                config.setFileLoadingMaxSize(this.fileLoadingMaxSize);
                log.logBasic("Explorer perspective: the file loading maximum size (in MB) is set to '" + this.fileLoadingMaxSize + "'");
                changed = true;
            }
            if (changed) {
                ExplorerPerspectiveConfigSingleton.saveConfig();
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling explorer perspective configuration options", (Throwable)e);
        }
    }

    @Override
    public void widgetsCreated(GuiCompositeWidgets compositeWidgets) {
    }

    @Override
    public void widgetsPopulated(GuiCompositeWidgets compositeWidgets) {
    }

    @Override
    public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
        this.persistContents(compositeWidgets);
    }

    @Override
    public void persistContents(GuiCompositeWidgets compositeWidgets) {
        for (String widgetId : compositeWidgets.getWidgetsMap().keySet()) {
            Control control = compositeWidgets.getWidgetsMap().get(widgetId);
            switch (widgetId) {
                case "10000-lazy-loading-depth": {
                    this.lazyLoadingDepth = ((TextVar)control).getText();
                    ExplorerPerspectiveConfigSingleton.getConfig().setLazyLoadingDepth(this.lazyLoadingDepth);
                    break;
                }
                case "10100-file-loading-max-size": {
                    this.fileLoadingMaxSize = ((TextVar)control).getText();
                    ExplorerPerspectiveConfigSingleton.getConfig().setFileLoadingMaxSize(this.fileLoadingMaxSize);
                }
            }
        }
        try {
            ExplorerPerspectiveConfigSingleton.saveConfig();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving option", e);
        }
    }

    public String getLazyLoadingDepth() {
        return this.lazyLoadingDepth;
    }

    public void setLazyLoadingDepth(String lazyLoadingDepth) {
        this.lazyLoadingDepth = lazyLoadingDepth;
    }

    public String getFileLoadingMaxSize() {
        return this.fileLoadingMaxSize;
    }

    public void setFileLoadingMaxSize(String fileLoadingMaxSize) {
        this.fileLoadingMaxSize = fileLoadingMaxSize;
    }
}

