/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.delegates;

import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.history.AuditEvent;
import org.apache.hop.history.AuditManager;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelineSvgPainter;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.SelectRowDialog;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.HopFileTypeRegistry;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.WorkflowSvgPainter;

public class HopGuiFileDelegate {
    public static final String CONST_ERROR = "Error";
    private final HopGui hopGui;

    public HopGuiFileDelegate(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    public IHopFileTypeHandler getActiveFileTypeHandler() {
        return this.hopGui.getActivePerspective().getActiveFileTypeHandler();
    }

    public void fileOpen() {
        try {
            HopFileTypeRegistry fileRegistry = HopFileTypeRegistry.getInstance();
            String filename = BaseDialog.presentFileDialog(this.hopGui.getShell(), fileRegistry.getFilterExtensions(), fileRegistry.getFilterNames(), true);
            if (filename == null) {
                return;
            }
            this.fileOpen(this.hopGui.getVariables().resolve(filename));
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getActiveShell(), CONST_ERROR, "Error opening file", e);
        }
    }

    public IHopFileTypeHandler fileOpen(String filename) throws Exception {
        HopFileTypeRegistry fileRegistry = HopFileTypeRegistry.getInstance();
        IHopFileType hopFile = fileRegistry.findHopFileType(filename);
        if (hopFile == null) {
            throw new HopException("We looked at " + fileRegistry.getFileTypes().size() + " different Hop GUI file types but none know how to open file '" + filename + "'");
        }
        IHopFileTypeHandler fileTypeHandler = hopFile.openFile(this.hopGui, filename, this.hopGui.getVariables());
        if (fileTypeHandler != null) {
            this.hopGui.handleFileCapabilities(hopFile, fileTypeHandler.hasChanged(), false, false);
            if (EnvironmentUtils.getInstance().isWeb()) {
                this.hopGui.handleFileCapabilities(hopFile, fileTypeHandler.hasChanged(), false, false);
            }
            this.hopGui.auditDelegate.writeLastOpenFiles();
        }
        return fileTypeHandler;
    }

    public String fileSaveAs() {
        try {
            String filename;
            IHopFileTypeHandler typeHandler = this.getActiveFileTypeHandler();
            IHopFileType fileType = typeHandler.getFileType();
            FileObject file = null;
            if (!fileType.hasCapability("SaveAs")) {
                return null;
            }
            if (typeHandler.getFilename() != null) {
                file = HopVfs.getFileObject((String)typeHandler.getFilename());
            }
            if ((filename = BaseDialog.presentFileDialog(true, this.hopGui.getShell(), null, file, fileType.getFilterExtensions(), fileType.getFilterNames(), true)) == null) {
                return null;
            }
            filename = this.hopGui.getVariables().resolve(filename);
            typeHandler.saveAs(filename);
            this.hopGui.auditDelegate.writeLastOpenFiles();
            return filename;
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getActiveShell(), CONST_ERROR, "Error saving file", e);
            return null;
        }
    }

    public void fileSave() {
        try {
            IHopFileTypeHandler typeHandler = this.getActiveFileTypeHandler();
            IHopFileType fileType = typeHandler.getFileType();
            if (fileType.hasCapability("Save")) {
                if (StringUtils.isEmpty((String)typeHandler.getFilename()) && !fileType.hasCapability("HandleMetadata")) {
                    this.fileSaveAs();
                } else {
                    typeHandler.save();
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getActiveShell(), CONST_ERROR, "Error saving file", e);
        }
    }

    public boolean fileClose() {
        try {
            IHopPerspective perspective = this.hopGui.getActivePerspective();
            IHopFileTypeHandler typeHandler = this.getActiveFileTypeHandler();
            IHopFileType fileType = typeHandler.getFileType();
            if (fileType.hasCapability("Close")) {
                perspective.remove(typeHandler);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getActiveShell(), CONST_ERROR, "Error saving/closing file", e);
        }
        return false;
    }

    public boolean saveGuardAllFiles() {
        for (IHopPerspective perspective : this.hopGui.getPerspectiveManager().getPerspectives()) {
            List<TabItemHandler> tabItemHandlers = perspective.getItems();
            if (tabItemHandlers == null) continue;
            for (TabItemHandler tabItemHandler : tabItemHandlers) {
                IHopFileTypeHandler typeHandler = tabItemHandler.getTypeHandler();
                if (typeHandler.isCloseable()) continue;
                return false;
            }
        }
        return true;
    }

    public void closeAllFiles() {
        for (IHopPerspective perspective : this.hopGui.getPerspectiveManager().getPerspectives()) {
            List<TabItemHandler> tabItemHandlers = perspective.getItems();
            if (tabItemHandlers == null) continue;
            ArrayList<TabItemHandler> handlers = new ArrayList<TabItemHandler>(tabItemHandlers);
            for (TabItemHandler tabItemHandler : handlers) {
                IHopFileTypeHandler typeHandler = tabItemHandler.getTypeHandler();
                typeHandler.close();
            }
        }
    }

    public boolean fileExit() {
        if (!this.saveGuardAllFiles()) {
            return false;
        }
        this.hopGui.auditDelegate.writeLastOpenFiles();
        return true;
    }

    public void fileOpenRecent() {
        IHopPerspective perspective = this.hopGui.getActivePerspective();
        try {
            String filename;
            List events = AuditManager.findEvents((String)HopNamespace.getNamespace(), (String)"file", (String)"open", (int)100, (boolean)true);
            HashSet<String> filenames = new HashSet<String>();
            ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
            RowMeta rowMeta = new RowMeta();
            rowMeta.addValueMeta((IValueMeta)new ValueMetaString("filename"));
            rowMeta.addValueMeta((IValueMeta)new ValueMetaString("operation"));
            rowMeta.addValueMeta((IValueMeta)new ValueMetaString("date"));
            for (AuditEvent event : events) {
                filename = event.getName();
                if (filenames.contains(filename)) continue;
                filenames.add(filename);
                String operation = event.getOperation();
                String dateString = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(event.getDate());
                rows.add(new RowMetaAndData((IRowMeta)rowMeta, new Object[]{filename, operation, dateString}));
            }
            SelectRowDialog rowDialog = new SelectRowDialog(this.hopGui.getShell(), this.hopGui.getVariables(), 0, rows);
            rowDialog.setTitle("Select the file to open");
            RowMetaAndData row = rowDialog.open();
            if (row != null) {
                filename = row.getString("filename", null);
                this.hopGui.fileDelegate.fileOpen(filename);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getActiveShell(), CONST_ERROR, "Error getting list of recently opened files", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToSvg() {
        block10: {
            try {
                HopGuiWorkflowGraph workflowGraph;
                String svgXml = null;
                IVariables variables = null;
                String proposedName = null;
                HopGuiPipelineGraph pipelineGraph = HopGui.getActivePipelineGraph();
                if (pipelineGraph != null) {
                    PipelineMeta pipelineMeta = pipelineGraph.getPipelineMeta();
                    variables = pipelineGraph.getVariables();
                    svgXml = PipelineSvgPainter.generatePipelineSvg((PipelineMeta)pipelineMeta, (float)1.0f, (IVariables)pipelineGraph.getVariables());
                    proposedName = pipelineMeta.getName() + ".svg";
                }
                if ((workflowGraph = HopGui.getActiveWorkflowGraph()) != null) {
                    WorkflowMeta workflowMeta = workflowGraph.getWorkflowMeta();
                    variables = workflowGraph.getVariables();
                    svgXml = WorkflowSvgPainter.generateWorkflowSvg((WorkflowMeta)workflowMeta, (float)1.0f, (IVariables)workflowGraph.getVariables());
                    proposedName = workflowMeta.getName() + ".svg";
                }
                if (svgXml == null) break block10;
                String proposedFilename = variables.getVariable("user.home") + File.separator + proposedName;
                FileObject proposedFile = HopVfs.getFileObject((String)proposedFilename);
                String filename = BaseDialog.presentFileDialog(true, this.hopGui.getShell(), null, variables, proposedFile, new String[]{"*.svg"}, new String[]{"SVG Files"}, true);
                if (filename == null) break block10;
                String realFilename = variables.resolve(filename);
                FileObject file = HopVfs.getFileObject((String)realFilename);
                if (file.exists()) {
                    MessageBox box = new MessageBox(this.hopGui.getActiveShell(), 196);
                    box.setText("File exists");
                    box.setMessage("This file already exists. Do you want to overwrite it?");
                    int answer = box.open();
                    if ((answer & 0x40) == 0) {
                        return;
                    }
                }
                try (OutputStream outputStream = null;){
                    outputStream = HopVfs.getOutputStream((FileObject)file, (boolean)false);
                    outputStream.write(svgXml.getBytes("UTF-8"));
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.hopGui.getActiveShell(), CONST_ERROR, "Error exporting to SVG", e);
            }
        }
    }
}

