/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.stanford.nlp.simple;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.stanford.nlp.simple.StanfordSimpleNlpMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StanfordSimpleNlpDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = StanfordSimpleNlpDialog.class;
    private final StanfordSimpleNlpMeta input;
    private boolean gotPreviousFields = false;
    private CCombo wCorpusFieldName;
    private Button wIncludePartOfSpeech;
    private Button wParallelism;
    private Label wlOutputFieldNamePrefix;
    private FormData fdlOutputFieldNamePrefix;
    private FormData fdOutputFieldNamePrefix;
    private Text wOutputFieldNamePrefix;

    public StanfordSimpleNlpDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (ITransformMeta)((BaseTransformMeta)in), pipelineMeta, sname);
        this.input = (StanfordSimpleNlpMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"StanfordSimpleNlpDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"StanfordSimpleNlpDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlCorpusFieldName = new Label((Composite)this.shell, 131072);
        wlCorpusFieldName.setText(BaseMessages.getString(PKG, (String)"StanfordSimpleNlpDialog.CorpusFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCorpusFieldName);
        FormData fdlCorpusFieldName = new FormData();
        fdlCorpusFieldName.left = new FormAttachment(0, 0);
        fdlCorpusFieldName.right = new FormAttachment(middle, -margin);
        fdlCorpusFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        wlCorpusFieldName.setLayoutData((Object)fdlCorpusFieldName);
        this.wCorpusFieldName = new CCombo((Composite)this.shell, 2056);
        PropsUi.setLook((Widget)this.wCorpusFieldName);
        this.wCorpusFieldName.addModifyListener(lsMod);
        FormData fdCorpusFieldName = new FormData();
        fdCorpusFieldName.left = new FormAttachment(middle, 0);
        fdCorpusFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        fdCorpusFieldName.right = new FormAttachment(100, -margin);
        this.wCorpusFieldName.setLayoutData((Object)fdCorpusFieldName);
        this.wCorpusFieldName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)StanfordSimpleNlpDialog.this.shell.getDisplay(), 1);
                StanfordSimpleNlpDialog.this.shell.setCursor(busy);
                StanfordSimpleNlpDialog.this.get();
                StanfordSimpleNlpDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlOutputFieldNamePrefix = new Label((Composite)this.shell, 131072);
        this.wlOutputFieldNamePrefix.setText(BaseMessages.getString(PKG, (String)"StanfordSimpleNlpDialog.OutputFieldNamePrefix.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlOutputFieldNamePrefix);
        this.fdlOutputFieldNamePrefix = new FormData();
        this.fdlOutputFieldNamePrefix.left = new FormAttachment(0, 0);
        this.fdlOutputFieldNamePrefix.right = new FormAttachment(middle, -margin);
        this.fdlOutputFieldNamePrefix.top = new FormAttachment((Control)this.wCorpusFieldName, margin);
        this.wlOutputFieldNamePrefix.setLayoutData((Object)this.fdlOutputFieldNamePrefix);
        this.wOutputFieldNamePrefix = new Text((Composite)this.shell, 18436);
        this.wOutputFieldNamePrefix.setText(this.input.getOutputFieldNamePrefix());
        PropsUi.setLook((Widget)this.wOutputFieldNamePrefix);
        this.wOutputFieldNamePrefix.addModifyListener(lsMod);
        this.fdOutputFieldNamePrefix = new FormData();
        this.fdOutputFieldNamePrefix.left = new FormAttachment(middle, 0);
        this.fdOutputFieldNamePrefix.top = new FormAttachment((Control)this.wCorpusFieldName, margin);
        this.fdOutputFieldNamePrefix.right = new FormAttachment(100, 0);
        this.wOutputFieldNamePrefix.setLayoutData((Object)this.fdOutputFieldNamePrefix);
        Label wlIncludePartOfSpeech = new Label((Composite)this.shell, 131072);
        wlIncludePartOfSpeech.setText(BaseMessages.getString(PKG, (String)"StanfordSimpleNlpDialog.IncludePartOfSpeech.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIncludePartOfSpeech);
        FormData fdlIncludePartOfSpeech = new FormData();
        fdlIncludePartOfSpeech.left = new FormAttachment(0, 0);
        fdlIncludePartOfSpeech.top = new FormAttachment((Control)this.wOutputFieldNamePrefix, margin);
        fdlIncludePartOfSpeech.right = new FormAttachment(middle, -2 * margin);
        wlIncludePartOfSpeech.setLayoutData((Object)fdlIncludePartOfSpeech);
        this.wIncludePartOfSpeech = new Button((Composite)this.shell, 32);
        this.wIncludePartOfSpeech.setSelection(this.input.isIncludePartOfSpeech());
        PropsUi.setLook((Widget)this.wIncludePartOfSpeech);
        this.wIncludePartOfSpeech.setToolTipText(BaseMessages.getString(PKG, (String)"StanfordSimpleNlpDialog.IncludePartOfSpeech.Tooltip", (String[])new String[0]));
        FormData fdIncludePartOfSpeech = new FormData();
        fdIncludePartOfSpeech.left = new FormAttachment(middle, -margin);
        fdIncludePartOfSpeech.top = new FormAttachment((Control)this.wOutputFieldNamePrefix, margin * 2);
        fdIncludePartOfSpeech.right = new FormAttachment(100, 0);
        this.wIncludePartOfSpeech.setLayoutData((Object)fdIncludePartOfSpeech);
        this.wIncludePartOfSpeech.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StanfordSimpleNlpDialog.this.input.setChanged();
            }
        });
        Label wlParallelism = new Label((Composite)this.shell, 131072);
        wlParallelism.setText(BaseMessages.getString(PKG, (String)"StanfordSimpleNlpDialog.Parallelism.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlParallelism);
        FormData fdlParallelism = new FormData();
        fdlParallelism.left = new FormAttachment(0, 0);
        fdlParallelism.top = new FormAttachment((Control)this.wIncludePartOfSpeech, margin);
        fdlParallelism.right = new FormAttachment(middle, -2 * margin);
        wlParallelism.setLayoutData((Object)fdlParallelism);
        this.wParallelism = new Button((Composite)this.shell, 32);
        this.wParallelism.setSelection(this.input.isParallelism());
        PropsUi.setLook((Widget)this.wParallelism);
        this.wParallelism.setToolTipText(BaseMessages.getString(PKG, (String)"StanfordSimpleNlpDialog.Parallelism.Tooltip", (String[])new String[0]));
        FormData fdParallelism = new FormData();
        fdParallelism.left = new FormAttachment(middle, -margin);
        fdParallelism.top = new FormAttachment((Control)this.wIncludePartOfSpeech, margin * 2);
        fdParallelism.right = new FormAttachment(100, 0);
        this.wParallelism.setLayoutData((Object)fdParallelism);
        this.wParallelism.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StanfordSimpleNlpDialog.this.input.setChanged();
            }
        });
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wParallelism);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.input.getCorpusField() != null) {
            this.wCorpusFieldName.setText(this.input.getCorpusField());
        }
        if (this.input.isIncludePartOfSpeech()) {
            this.wIncludePartOfSpeech.setEnabled(this.input.isIncludePartOfSpeech());
        }
        if (this.input.isParallelism()) {
            this.wParallelism.setEnabled(this.input.isParallelism());
        }
        if (this.input.getOutputFieldNamePrefix() != null) {
            this.wOutputFieldNamePrefix.setText(this.input.getOutputFieldNamePrefix());
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setCorpusField(this.wCorpusFieldName.getText());
        this.input.setIncludePartOfSpeech(this.wIncludePartOfSpeech.getSelection());
        this.input.setParallelism(this.wParallelism.getSelection());
        this.input.setOutputFieldNamePrefix(this.wOutputFieldNamePrefix.getText());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            try {
                String corpusField = null;
                if (this.wCorpusFieldName.getText() != null) {
                    corpusField = this.wCorpusFieldName.getText();
                }
                this.wCorpusFieldName.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wCorpusFieldName.setItems(r.getFieldNames());
                }
                if (corpusField != null) {
                    this.wCorpusFieldName.setText(corpusField);
                }
                this.gotPreviousFields = true;
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"StanfordSimpleNlpDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StanfordSimpleNlpDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

