/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.list;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JobQueueListItem {
    String jobQueueName;
    String jobQueueLibrary;
    String jobQueueDescription;
    String subsystemName;
    String subsystemLibrary;
    int numberOfJobsWaitingToRun;
    int numberOfJobsRunning;
    int maximumActiveJobs;
    JobQueueStatus jobQueueStatus;
    int jobQueueSequence;
    String aspName;

    JobQueueListItem() {
    }

    public String getJobQueueName() {
        return this.jobQueueName;
    }

    public String getJobQueueLibrary() {
        return this.jobQueueLibrary;
    }

    public String getJobQueueDescription() {
        return this.jobQueueDescription;
    }

    public String getSubsystemName() {
        return this.subsystemName;
    }

    public String getSubsystemLibrary() {
        return this.subsystemLibrary;
    }

    public int getNumberOfJobsWaitingToRun() {
        return this.numberOfJobsWaitingToRun;
    }

    public int getNumberOfJobsRunning() {
        return this.numberOfJobsRunning;
    }

    public int getMaximumActiveJobs() {
        return this.maximumActiveJobs;
    }

    public JobQueueStatus getJobQueueStatus() {
        return this.jobQueueStatus;
    }

    public int getJobQueueSequence() {
        return this.jobQueueSequence;
    }

    public String getAspName() {
        return this.aspName;
    }

    public static enum JobQueueStatus {
        HELD("0"),
        RELEASED("1"),
        DAMAGED("2"),
        DEFINED("3");

        private final String systemValue;
        private static Map<String, JobQueueStatus> valToEnum;

        private JobQueueStatus(String sysVal) {
            this.systemValue = sysVal;
        }

        private static Map<String, JobQueueStatus> createMap() {
            HashMap<String, JobQueueStatus> map = new HashMap<String, JobQueueStatus>();
            for (JobQueueStatus item : JobQueueStatus.values()) {
                map.put(item.getSystemValue(), item);
            }
            return Collections.unmodifiableMap(map);
        }

        public String getSystemValue() {
            return this.systemValue;
        }

        public static JobQueueStatus fromSystemValue(String systemValue) {
            return valToEnum.get(systemValue);
        }

        static {
            valToEnum = JobQueueStatus.createMap();
        }
    }
}

