/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.time.Duration;

public class HybridShuffleConfiguration {
    private static final int DEFAULT_MAX_BUFFERS_READ_AHEAD = 5;
    private static final Duration DEFAULT_BUFFER_REQUEST_TIMEOUT = Duration.ofMinutes(5L);
    private static final float DEFAULT_SELECTIVE_STRATEGY_SPILL_THRESHOLD = 0.7f;
    private static final float DEFAULT_SELECTIVE_STRATEGY_SPILL_BUFFER_RATIO = 0.4f;
    private static final float DEFAULT_FULL_STRATEGY_NUM_BUFFERS_TRIGGER_SPILLED_RATIO = 0.5f;
    private static final float DEFAULT_FULL_STRATEGY_RELEASE_THRESHOLD = 0.7f;
    private static final float DEFAULT_FULL_STRATEGY_RELEASE_BUFFER_RATIO = 0.4f;
    private static final long DEFAULT_BUFFER_POLL_SIZE_CHECK_INTERVAL_MS = 1000L;
    private static final long DEFAULT_NUM_RETAINED_IN_MEMORY_REGIONS_MAX = Long.MAX_VALUE;
    private static final int DEFAULT_REGION_GROUP_SIZE_IN_BYTES = 256;
    private static final SpillingStrategyType DEFAULT_SPILLING_STRATEGY_NAME = SpillingStrategyType.FULL;
    private final int maxBuffersReadAhead;
    private final Duration bufferRequestTimeout;
    private final int maxRequestedBuffers;
    private final SpillingStrategyType spillingStrategyType;
    private final long numRetainedInMemoryRegionsMax;
    private final int regionGroupSizeInBytes;
    private final long bufferPoolSizeCheckIntervalMs;
    private final float selectiveStrategySpillThreshold;
    private final float selectiveStrategySpillBufferRatio;
    private final float fullStrategyNumBuffersTriggerSpillingRatio;
    private final float fullStrategyReleaseThreshold;
    private final float fullStrategyReleaseBufferRatio;

    private HybridShuffleConfiguration(int maxBuffersReadAhead, Duration bufferRequestTimeout, int maxRequestedBuffers, float selectiveStrategySpillThreshold, float selectiveStrategySpillBufferRatio, float fullStrategyNumBuffersTriggerSpillingRatio, float fullStrategyReleaseThreshold, float fullStrategyReleaseBufferRatio, SpillingStrategyType spillingStrategyType, long bufferPoolSizeCheckIntervalMs, long numRetainedInMemoryRegionsMax, int regionGroupSizeInBytes) {
        this.maxBuffersReadAhead = maxBuffersReadAhead;
        this.bufferRequestTimeout = bufferRequestTimeout;
        this.maxRequestedBuffers = maxRequestedBuffers;
        this.selectiveStrategySpillThreshold = selectiveStrategySpillThreshold;
        this.selectiveStrategySpillBufferRatio = selectiveStrategySpillBufferRatio;
        this.fullStrategyNumBuffersTriggerSpillingRatio = fullStrategyNumBuffersTriggerSpillingRatio;
        this.fullStrategyReleaseThreshold = fullStrategyReleaseThreshold;
        this.fullStrategyReleaseBufferRatio = fullStrategyReleaseBufferRatio;
        this.spillingStrategyType = spillingStrategyType;
        this.bufferPoolSizeCheckIntervalMs = bufferPoolSizeCheckIntervalMs;
        this.numRetainedInMemoryRegionsMax = numRetainedInMemoryRegionsMax;
        this.regionGroupSizeInBytes = regionGroupSizeInBytes;
    }

    public static Builder builder(int numSubpartitions, int numBuffersPerRequest) {
        return new Builder(numSubpartitions, numBuffersPerRequest);
    }

    public SpillingStrategyType getSpillingStrategyType() {
        return this.spillingStrategyType;
    }

    public int getMaxRequestedBuffers() {
        return this.maxRequestedBuffers;
    }

    public int getMaxBuffersReadAhead() {
        return this.maxBuffersReadAhead;
    }

    public Duration getBufferRequestTimeout() {
        return this.bufferRequestTimeout;
    }

    public float getSelectiveStrategySpillThreshold() {
        return this.selectiveStrategySpillThreshold;
    }

    public float getSelectiveStrategySpillBufferRatio() {
        return this.selectiveStrategySpillBufferRatio;
    }

    public float getFullStrategyNumBuffersTriggerSpillingRatio() {
        return this.fullStrategyNumBuffersTriggerSpillingRatio;
    }

    public float getFullStrategyReleaseThreshold() {
        return this.fullStrategyReleaseThreshold;
    }

    public float getFullStrategyReleaseBufferRatio() {
        return this.fullStrategyReleaseBufferRatio;
    }

    public long getBufferPoolSizeCheckIntervalMs() {
        return this.bufferPoolSizeCheckIntervalMs;
    }

    public int getRegionGroupSizeInBytes() {
        return this.regionGroupSizeInBytes;
    }

    public long getNumRetainedInMemoryRegionsMax() {
        return this.numRetainedInMemoryRegionsMax;
    }

    static /* synthetic */ Duration access$100() {
        return DEFAULT_BUFFER_REQUEST_TIMEOUT;
    }

    static /* synthetic */ SpillingStrategyType access$200() {
        return DEFAULT_SPILLING_STRATEGY_NAME;
    }

    public static class Builder {
        private int maxBuffersReadAhead = 5;
        private Duration bufferRequestTimeout = HybridShuffleConfiguration.access$100();
        private float selectiveStrategySpillThreshold = 0.7f;
        private float selectiveStrategySpillBufferRatio = 0.4f;
        private float fullStrategyNumBuffersTriggerSpillingRatio = 0.5f;
        private float fullStrategyReleaseThreshold = 0.7f;
        private float fullStrategyReleaseBufferRatio = 0.4f;
        private long bufferPoolSizeCheckIntervalMs = 1000L;
        private SpillingStrategyType spillingStrategyType = HybridShuffleConfiguration.access$200();
        private long numRetainedInMemoryRegionsMax = Long.MAX_VALUE;
        private int regionGroupSizeInBytes = 256;
        private final int numSubpartitions;
        private final int numBuffersPerRequest;

        private Builder(int numSubpartitions, int numBuffersPerRequest) {
            this.numSubpartitions = numSubpartitions;
            this.numBuffersPerRequest = numBuffersPerRequest;
        }

        public Builder setMaxBuffersReadAhead(int maxBuffersReadAhead) {
            this.maxBuffersReadAhead = maxBuffersReadAhead;
            return this;
        }

        public Builder setBufferRequestTimeout(Duration bufferRequestTimeout) {
            this.bufferRequestTimeout = bufferRequestTimeout;
            return this;
        }

        public Builder setSelectiveStrategySpillThreshold(float selectiveStrategySpillThreshold) {
            this.selectiveStrategySpillThreshold = selectiveStrategySpillThreshold;
            return this;
        }

        public Builder setSelectiveStrategySpillBufferRatio(float selectiveStrategySpillBufferRatio) {
            this.selectiveStrategySpillBufferRatio = selectiveStrategySpillBufferRatio;
            return this;
        }

        public Builder setFullStrategyNumBuffersTriggerSpillingRatio(float fullStrategyNumBuffersTriggerSpillingRatio) {
            this.fullStrategyNumBuffersTriggerSpillingRatio = fullStrategyNumBuffersTriggerSpillingRatio;
            return this;
        }

        public Builder setFullStrategyReleaseThreshold(float fullStrategyReleaseThreshold) {
            this.fullStrategyReleaseThreshold = fullStrategyReleaseThreshold;
            return this;
        }

        public Builder setFullStrategyReleaseBufferRatio(float fullStrategyReleaseBufferRatio) {
            this.fullStrategyReleaseBufferRatio = fullStrategyReleaseBufferRatio;
            return this;
        }

        public Builder setSpillingStrategyType(SpillingStrategyType spillingStrategyType) {
            this.spillingStrategyType = spillingStrategyType;
            return this;
        }

        public Builder setBufferPoolSizeCheckIntervalMs(long bufferPoolSizeCheckIntervalMs) {
            this.bufferPoolSizeCheckIntervalMs = bufferPoolSizeCheckIntervalMs;
            return this;
        }

        public Builder setNumRetainedInMemoryRegionsMax(long numRetainedInMemoryRegionsMax) {
            this.numRetainedInMemoryRegionsMax = numRetainedInMemoryRegionsMax;
            return this;
        }

        public Builder setRegionGroupSizeInBytes(int regionGroupSizeInBytes) {
            this.regionGroupSizeInBytes = regionGroupSizeInBytes;
            return this;
        }

        public HybridShuffleConfiguration build() {
            return new HybridShuffleConfiguration(this.maxBuffersReadAhead, this.bufferRequestTimeout, Math.max(2 * this.numBuffersPerRequest, this.numSubpartitions), this.selectiveStrategySpillThreshold, this.selectiveStrategySpillBufferRatio, this.fullStrategyNumBuffersTriggerSpillingRatio, this.fullStrategyReleaseThreshold, this.fullStrategyReleaseBufferRatio, this.spillingStrategyType, this.bufferPoolSizeCheckIntervalMs, this.numRetainedInMemoryRegionsMax, this.regionGroupSizeInBytes);
        }
    }

    public static enum SpillingStrategyType {
        FULL,
        SELECTIVE;

    }
}

