/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.common.RootInfo;
import com.dropbox.core.v2.users.Account;
import com.dropbox.core.v2.users.FullTeam;
import com.dropbox.core.v2.users.Name;
import com.dropbox.core.v2.userscommon.AccountType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FullAccount
extends Account {
    @Nullable
    protected final String country;
    @Nonnull
    protected final String locale;
    @Nonnull
    protected final String referralLink;
    @Nullable
    protected final FullTeam team;
    @Nullable
    protected final String teamMemberId;
    protected final boolean isPaired;
    @Nonnull
    protected final AccountType accountType;
    @Nonnull
    protected final RootInfo rootInfo;

    public FullAccount(@Nonnull String accountId, @Nonnull Name name, @Nonnull String email, boolean emailVerified, boolean disabled, @Nonnull String locale, @Nonnull String referralLink, boolean isPaired, @Nonnull AccountType accountType, @Nonnull RootInfo rootInfo, @Nullable String profilePhotoUrl, @Nullable String country, @Nullable FullTeam team, @Nullable String teamMemberId) {
        super(accountId, name, email, emailVerified, disabled, profilePhotoUrl);
        if (country != null) {
            if (country.length() < 2) {
                throw new IllegalArgumentException("String 'country' is shorter than 2");
            }
            if (country.length() > 2) {
                throw new IllegalArgumentException("String 'country' is longer than 2");
            }
        }
        this.country = country;
        if (locale == null) {
            throw new IllegalArgumentException("Required value for 'locale' is null");
        }
        if (locale.length() < 2) {
            throw new IllegalArgumentException("String 'locale' is shorter than 2");
        }
        this.locale = locale;
        if (referralLink == null) {
            throw new IllegalArgumentException("Required value for 'referralLink' is null");
        }
        this.referralLink = referralLink;
        this.team = team;
        this.teamMemberId = teamMemberId;
        this.isPaired = isPaired;
        if (accountType == null) {
            throw new IllegalArgumentException("Required value for 'accountType' is null");
        }
        this.accountType = accountType;
        if (rootInfo == null) {
            throw new IllegalArgumentException("Required value for 'rootInfo' is null");
        }
        this.rootInfo = rootInfo;
    }

    public FullAccount(@Nonnull String accountId, @Nonnull Name name, @Nonnull String email, boolean emailVerified, boolean disabled, @Nonnull String locale, @Nonnull String referralLink, boolean isPaired, @Nonnull AccountType accountType, @Nonnull RootInfo rootInfo) {
        this(accountId, name, email, emailVerified, disabled, locale, referralLink, isPaired, accountType, rootInfo, null, null, null, null);
    }

    @Override
    @Nonnull
    public String getAccountId() {
        return this.accountId;
    }

    @Override
    @Nonnull
    public Name getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getEmail() {
        return this.email;
    }

    @Override
    public boolean getEmailVerified() {
        return this.emailVerified;
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Nonnull
    public String getLocale() {
        return this.locale;
    }

    @Nonnull
    public String getReferralLink() {
        return this.referralLink;
    }

    public boolean getIsPaired() {
        return this.isPaired;
    }

    @Nonnull
    public AccountType getAccountType() {
        return this.accountType;
    }

    @Nonnull
    public RootInfo getRootInfo() {
        return this.rootInfo;
    }

    @Override
    @Nullable
    public String getProfilePhotoUrl() {
        return this.profilePhotoUrl;
    }

    @Nullable
    public String getCountry() {
        return this.country;
    }

    @Nullable
    public FullTeam getTeam() {
        return this.team;
    }

    @Nullable
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public static Builder newBuilder(String accountId, Name name, String email, boolean emailVerified, boolean disabled, String locale, String referralLink, boolean isPaired, AccountType accountType, RootInfo rootInfo) {
        return new Builder(accountId, name, email, emailVerified, disabled, locale, referralLink, isPaired, accountType, rootInfo);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.country, this.locale, this.referralLink, this.team, this.teamMemberId, this.isPaired, this.accountType, this.rootInfo});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FullAccount other = (FullAccount)obj;
            return !(this.accountId != other.accountId && !this.accountId.equals(other.accountId) || this.name != other.name && !this.name.equals(other.name) || this.email != other.email && !this.email.equals(other.email) || this.emailVerified != other.emailVerified || this.disabled != other.disabled || this.locale != other.locale && !this.locale.equals(other.locale) || this.referralLink != other.referralLink && !this.referralLink.equals(other.referralLink) || this.isPaired != other.isPaired || this.accountType != other.accountType && !this.accountType.equals((Object)other.accountType) || this.rootInfo != other.rootInfo && !this.rootInfo.equals(other.rootInfo) || this.profilePhotoUrl != other.profilePhotoUrl && (this.profilePhotoUrl == null || !this.profilePhotoUrl.equals(other.profilePhotoUrl)) || this.country != other.country && (this.country == null || !this.country.equals(other.country)) || this.team != other.team && (this.team == null || !this.team.equals(other.team)) || this.teamMemberId != other.teamMemberId && (this.teamMemberId == null || !this.teamMemberId.equals(other.teamMemberId)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FullAccount> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FullAccount value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("account_id");
            StoneSerializers.string().serialize(value.accountId, g);
            g.writeFieldName("name");
            Name.Serializer.INSTANCE.serialize(value.name, g);
            g.writeFieldName("email");
            StoneSerializers.string().serialize(value.email, g);
            g.writeFieldName("email_verified");
            StoneSerializers.boolean_().serialize((Boolean)value.emailVerified, g);
            g.writeFieldName("disabled");
            StoneSerializers.boolean_().serialize((Boolean)value.disabled, g);
            g.writeFieldName("locale");
            StoneSerializers.string().serialize(value.locale, g);
            g.writeFieldName("referral_link");
            StoneSerializers.string().serialize(value.referralLink, g);
            g.writeFieldName("is_paired");
            StoneSerializers.boolean_().serialize((Boolean)value.isPaired, g);
            g.writeFieldName("account_type");
            AccountType.Serializer.INSTANCE.serialize(value.accountType, g);
            g.writeFieldName("root_info");
            RootInfo.Serializer.INSTANCE.serialize(value.rootInfo, g);
            if (value.profilePhotoUrl != null) {
                g.writeFieldName("profile_photo_url");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.profilePhotoUrl, g);
            }
            if (value.country != null) {
                g.writeFieldName("country");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.country, g);
            }
            if (value.team != null) {
                g.writeFieldName("team");
                StoneSerializers.nullableStruct(FullTeam.Serializer.INSTANCE).serialize(value.team, g);
            }
            if (value.teamMemberId != null) {
                g.writeFieldName("team_member_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.teamMemberId, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FullAccount deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_teamMemberId;
            FullTeam f_team;
            String f_country;
            String f_profilePhotoUrl;
            RootInfo f_rootInfo;
            AccountType f_accountType;
            Boolean f_isPaired;
            String f_referralLink;
            String f_locale;
            Boolean f_disabled;
            Boolean f_emailVerified;
            String f_email;
            Name f_name;
            String f_accountId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_accountId = null;
                f_name = null;
                f_email = null;
                f_emailVerified = null;
                f_disabled = null;
                f_locale = null;
                f_referralLink = null;
                f_isPaired = null;
                f_accountType = null;
                f_rootInfo = null;
                f_profilePhotoUrl = null;
                f_country = null;
                f_team = null;
                f_teamMemberId = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("account_id".equals(field)) {
                        f_accountId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = (Name)Name.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("email".equals(field)) {
                        f_email = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("email_verified".equals(field)) {
                        f_emailVerified = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("disabled".equals(field)) {
                        f_disabled = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("locale".equals(field)) {
                        f_locale = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("referral_link".equals(field)) {
                        f_referralLink = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("is_paired".equals(field)) {
                        f_isPaired = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("account_type".equals(field)) {
                        f_accountType = AccountType.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("root_info".equals(field)) {
                        f_rootInfo = (RootInfo)RootInfo.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("profile_photo_url".equals(field)) {
                        f_profilePhotoUrl = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("country".equals(field)) {
                        f_country = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("team".equals(field)) {
                        f_team = StoneSerializers.nullableStruct(FullTeam.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("team_member_id".equals(field)) {
                        f_teamMemberId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_accountId == null) {
                    throw new JsonParseException(p, "Required field \"account_id\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_email == null) {
                    throw new JsonParseException(p, "Required field \"email\" missing.");
                }
                if (f_emailVerified == null) {
                    throw new JsonParseException(p, "Required field \"email_verified\" missing.");
                }
                if (f_disabled == null) {
                    throw new JsonParseException(p, "Required field \"disabled\" missing.");
                }
                if (f_locale == null) {
                    throw new JsonParseException(p, "Required field \"locale\" missing.");
                }
                if (f_referralLink == null) {
                    throw new JsonParseException(p, "Required field \"referral_link\" missing.");
                }
                if (f_isPaired == null) {
                    throw new JsonParseException(p, "Required field \"is_paired\" missing.");
                }
                if (f_accountType == null) {
                    throw new JsonParseException(p, "Required field \"account_type\" missing.");
                }
                if (f_rootInfo == null) {
                    throw new JsonParseException(p, "Required field \"root_info\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FullAccount value = new FullAccount(f_accountId, f_name, f_email, f_emailVerified, f_disabled, f_locale, f_referralLink, f_isPaired, f_accountType, f_rootInfo, f_profilePhotoUrl, f_country, f_team, f_teamMemberId);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String accountId;
        protected final Name name;
        protected final String email;
        protected final boolean emailVerified;
        protected final boolean disabled;
        protected final String locale;
        protected final String referralLink;
        protected final boolean isPaired;
        protected final AccountType accountType;
        protected final RootInfo rootInfo;
        protected String profilePhotoUrl;
        protected String country;
        protected FullTeam team;
        protected String teamMemberId;

        protected Builder(String accountId, Name name, String email, boolean emailVerified, boolean disabled, String locale, String referralLink, boolean isPaired, AccountType accountType, RootInfo rootInfo) {
            if (accountId == null) {
                throw new IllegalArgumentException("Required value for 'accountId' is null");
            }
            if (accountId.length() < 40) {
                throw new IllegalArgumentException("String 'accountId' is shorter than 40");
            }
            if (accountId.length() > 40) {
                throw new IllegalArgumentException("String 'accountId' is longer than 40");
            }
            this.accountId = accountId;
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (email == null) {
                throw new IllegalArgumentException("Required value for 'email' is null");
            }
            this.email = email;
            this.emailVerified = emailVerified;
            this.disabled = disabled;
            if (locale == null) {
                throw new IllegalArgumentException("Required value for 'locale' is null");
            }
            if (locale.length() < 2) {
                throw new IllegalArgumentException("String 'locale' is shorter than 2");
            }
            this.locale = locale;
            if (referralLink == null) {
                throw new IllegalArgumentException("Required value for 'referralLink' is null");
            }
            this.referralLink = referralLink;
            this.isPaired = isPaired;
            if (accountType == null) {
                throw new IllegalArgumentException("Required value for 'accountType' is null");
            }
            this.accountType = accountType;
            if (rootInfo == null) {
                throw new IllegalArgumentException("Required value for 'rootInfo' is null");
            }
            this.rootInfo = rootInfo;
            this.profilePhotoUrl = null;
            this.country = null;
            this.team = null;
            this.teamMemberId = null;
        }

        public Builder withProfilePhotoUrl(String profilePhotoUrl) {
            this.profilePhotoUrl = profilePhotoUrl;
            return this;
        }

        public Builder withCountry(String country) {
            if (country != null) {
                if (country.length() < 2) {
                    throw new IllegalArgumentException("String 'country' is shorter than 2");
                }
                if (country.length() > 2) {
                    throw new IllegalArgumentException("String 'country' is longer than 2");
                }
            }
            this.country = country;
            return this;
        }

        public Builder withTeam(FullTeam team) {
            this.team = team;
            return this;
        }

        public Builder withTeamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public FullAccount build() {
            return new FullAccount(this.accountId, this.name, this.email, this.emailVerified, this.disabled, this.locale, this.referralLink, this.isPaired, this.accountType, this.rootInfo, this.profilePhotoUrl, this.country, this.team, this.teamMemberId);
        }
    }
}

