/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class PaperUpdateError {
    public static final PaperUpdateError INSUFFICIENT_PERMISSIONS = new PaperUpdateError().withTag(Tag.INSUFFICIENT_PERMISSIONS);
    public static final PaperUpdateError CONTENT_MALFORMED = new PaperUpdateError().withTag(Tag.CONTENT_MALFORMED);
    public static final PaperUpdateError DOC_LENGTH_EXCEEDED = new PaperUpdateError().withTag(Tag.DOC_LENGTH_EXCEEDED);
    public static final PaperUpdateError IMAGE_SIZE_EXCEEDED = new PaperUpdateError().withTag(Tag.IMAGE_SIZE_EXCEEDED);
    public static final PaperUpdateError OTHER = new PaperUpdateError().withTag(Tag.OTHER);
    public static final PaperUpdateError REVISION_MISMATCH = new PaperUpdateError().withTag(Tag.REVISION_MISMATCH);
    public static final PaperUpdateError DOC_ARCHIVED = new PaperUpdateError().withTag(Tag.DOC_ARCHIVED);
    public static final PaperUpdateError DOC_DELETED = new PaperUpdateError().withTag(Tag.DOC_DELETED);
    private Tag _tag;
    private LookupError pathValue;

    private PaperUpdateError() {
    }

    private PaperUpdateError withTag(Tag _tag) {
        PaperUpdateError result = new PaperUpdateError();
        result._tag = _tag;
        return result;
    }

    private PaperUpdateError withTagAndPath(Tag _tag, LookupError pathValue) {
        PaperUpdateError result = new PaperUpdateError();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInsufficientPermissions() {
        return this._tag == Tag.INSUFFICIENT_PERMISSIONS;
    }

    public boolean isContentMalformed() {
        return this._tag == Tag.CONTENT_MALFORMED;
    }

    public boolean isDocLengthExceeded() {
        return this._tag == Tag.DOC_LENGTH_EXCEEDED;
    }

    public boolean isImageSizeExceeded() {
        return this._tag == Tag.IMAGE_SIZE_EXCEEDED;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static PaperUpdateError path(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new PaperUpdateError().withTagAndPath(Tag.PATH, value);
    }

    public LookupError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isRevisionMismatch() {
        return this._tag == Tag.REVISION_MISMATCH;
    }

    public boolean isDocArchived() {
        return this._tag == Tag.DOC_ARCHIVED;
    }

    public boolean isDocDeleted() {
        return this._tag == Tag.DOC_DELETED;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PaperUpdateError) {
            PaperUpdateError other = (PaperUpdateError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case INSUFFICIENT_PERMISSIONS: {
                    return true;
                }
                case CONTENT_MALFORMED: {
                    return true;
                }
                case DOC_LENGTH_EXCEEDED: {
                    return true;
                }
                case IMAGE_SIZE_EXCEEDED: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case REVISION_MISMATCH: {
                    return true;
                }
                case DOC_ARCHIVED: {
                    return true;
                }
                case DOC_DELETED: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<PaperUpdateError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperUpdateError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case INSUFFICIENT_PERMISSIONS: {
                    g.writeString("insufficient_permissions");
                    break;
                }
                case CONTENT_MALFORMED: {
                    g.writeString("content_malformed");
                    break;
                }
                case DOC_LENGTH_EXCEEDED: {
                    g.writeString("doc_length_exceeded");
                    break;
                }
                case IMAGE_SIZE_EXCEEDED: {
                    g.writeString("image_size_exceeded");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case PATH: {
                    g.writeStartObject();
                    this.writeTag("path", g);
                    g.writeFieldName("path");
                    LookupError.Serializer.INSTANCE.serialize(value.pathValue, g);
                    g.writeEndObject();
                    break;
                }
                case REVISION_MISMATCH: {
                    g.writeString("revision_mismatch");
                    break;
                }
                case DOC_ARCHIVED: {
                    g.writeString("doc_archived");
                    break;
                }
                case DOC_DELETED: {
                    g.writeString("doc_deleted");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public PaperUpdateError deserialize(JsonParser p) throws IOException, JsonParseException {
            PaperUpdateError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("insufficient_permissions".equals(tag)) {
                value = INSUFFICIENT_PERMISSIONS;
            } else if ("content_malformed".equals(tag)) {
                value = CONTENT_MALFORMED;
            } else if ("doc_length_exceeded".equals(tag)) {
                value = DOC_LENGTH_EXCEEDED;
            } else if ("image_size_exceeded".equals(tag)) {
                value = IMAGE_SIZE_EXCEEDED;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("path".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = PaperUpdateError.path(fieldValue);
            } else if ("revision_mismatch".equals(tag)) {
                value = REVISION_MISMATCH;
            } else if ("doc_archived".equals(tag)) {
                value = DOC_ARCHIVED;
            } else if ("doc_deleted".equals(tag)) {
                value = DOC_DELETED;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        INSUFFICIENT_PERMISSIONS,
        CONTENT_MALFORMED,
        DOC_LENGTH_EXCEEDED,
        IMAGE_SIZE_EXCEEDED,
        OTHER,
        PATH,
        REVISION_MISMATCH,
        DOC_ARCHIVED,
        DOC_DELETED;

    }
}

