/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.opencensus.implcore.stats;

import com.clickhouse.client.internal.opencensus.implcore.stats.MeasureMapInternal;
import com.clickhouse.client.internal.opencensus.implcore.stats.StatsManager;
import com.clickhouse.client.internal.opencensus.metrics.data.AttachmentValue;
import com.clickhouse.client.internal.opencensus.stats.Measure;
import com.clickhouse.client.internal.opencensus.stats.MeasureMap;
import com.clickhouse.client.internal.opencensus.tags.TagContext;
import com.clickhouse.client.internal.opencensus.tags.unsafe.ContextUtils;
import io.grpc.Context;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MeasureMapImpl
extends MeasureMap {
    private static final Logger logger = Logger.getLogger(MeasureMapImpl.class.getName());
    private final StatsManager statsManager;
    private final MeasureMapInternal.Builder builder = MeasureMapInternal.builder();
    private volatile boolean hasUnsupportedValues;

    static MeasureMapImpl create(StatsManager statsManager) {
        return new MeasureMapImpl(statsManager);
    }

    private MeasureMapImpl(StatsManager statsManager) {
        this.statsManager = statsManager;
    }

    @Override
    public MeasureMapImpl put(Measure.MeasureDouble measure, double value) {
        if (value < 0.0) {
            this.hasUnsupportedValues = true;
        }
        this.builder.put(measure, value);
        return this;
    }

    @Override
    public MeasureMapImpl put(Measure.MeasureLong measure, long value) {
        if (value < 0L) {
            this.hasUnsupportedValues = true;
        }
        this.builder.put(measure, value);
        return this;
    }

    @Override
    public MeasureMap putAttachment(String key, AttachmentValue value) {
        this.builder.putAttachment(key, value);
        return this;
    }

    @Override
    public void record() {
        this.record(ContextUtils.getValue(Context.current()));
    }

    @Override
    public void record(TagContext tags) {
        if (this.hasUnsupportedValues) {
            logger.log(Level.WARNING, "Dropping values, value to record must be non-negative.");
            return;
        }
        this.statsManager.record(tags, this.builder.build());
    }
}

