/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cache;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="CACHE", typeDescription="InterSystems Cache", documentationUrl="/database/databases/cache.html")
@GuiPlugin(id="GUI-CacheDatabaseMeta")
public class CacheDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public static final String CONST_ALTER_TABLE = "ALTER TABLE ";

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 1972;
        }
        return -1;
    }

    public boolean isSupportsSetCharacterStream() {
        return false;
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean isSupportsAutoInc() {
        return false;
    }

    public String getDriverClass() {
        return "com.intersys.jdbc.CacheDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:Cache://" + hostname + ":" + port + "/" + databaseName;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " ADD COLUMN ( " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false) + " ) ";
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " DROP COLUMN " + v.getName() + Const.CR;
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return CONST_ALTER_TABLE + tableName + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        Object retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = (String)retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk)) {
                    retval = (String)retval + "DECIMAL";
                    break;
                }
                if (type == 5) {
                    if (length > 9) {
                        retval = (String)retval + "DECIMAL(" + length + ")";
                        break;
                    }
                    retval = (String)retval + "INT";
                    break;
                }
                if (type == 6) {
                    if (length < 1) {
                        length = 16;
                    }
                    if (precision < 1) {
                        precision = 16;
                    }
                    retval = (String)retval + "DECIMAL(" + length + "," + precision + ")";
                    break;
                }
                retval = (String)retval + "DOUBLE";
                break;
            }
            case 2: {
                retval = (String)retval + "VARCHAR";
                if (length <= 0) break;
                retval = (String)retval + "(" + length + ")";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public boolean isRequiresCreateTablePrimaryKeyAppend() {
        return true;
    }

    public boolean isSupportsNewLinesInSql() {
        return false;
    }
}

