/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.time;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Public;
import org.apache.flink.util.Preconditions;

@Deprecated
@Public
public final class Time {
    private final TimeUnit unit;
    private final long size;

    @Nullable
    public static Duration toDuration(@Nullable Time time) {
        return time != null ? time.toDuration() : null;
    }

    @Nullable
    public static Time of(@Nullable Duration duration) {
        return duration != null ? Time.milliseconds(duration.toMillis()) : null;
    }

    private Time(long size, TimeUnit unit) {
        this.unit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)unit), (String)"time unit may not be null"));
        this.size = size;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long getSize() {
        return this.size;
    }

    public long toMilliseconds() {
        return this.unit.toMillis(this.size);
    }

    public Duration toDuration() {
        return Duration.ofMillis(this.toMilliseconds());
    }

    public static Time of(long size, TimeUnit unit) {
        return new Time(size, unit);
    }

    public static Time milliseconds(long milliseconds) {
        return Time.of(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static Time seconds(long seconds) {
        return Time.of(seconds, TimeUnit.SECONDS);
    }

    public static Time minutes(long minutes) {
        return Time.of(minutes, TimeUnit.MINUTES);
    }

    public static Time hours(long hours) {
        return Time.of(hours, TimeUnit.HOURS);
    }

    public static Time days(long days) {
        return Time.of(days, TimeUnit.DAYS);
    }
}

