/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.extra166y;

import groovyx.gpars.extra166y.Ops;
import java.util.Comparator;
import jsr166y.ThreadLocalRandom;

public class CommonOps {
    private CommonOps() {
    }

    public static <T extends Comparable<? super T>> Comparator<T> naturalComparator(Class<T> type) {
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a.compareTo(b);
            }
        };
    }

    public static <T extends Comparable<? super T>> Ops.Reducer<T> naturalMaxReducer(Class<T> type) {
        return new Ops.Reducer<T>(){

            @Override
            public T op(T a, T b) {
                return a != null && (b == null || a.compareTo(b) >= 0) ? a : b;
            }
        };
    }

    public static <T extends Comparable<? super T>> Ops.Reducer<T> naturalMinReducer(Class<T> type) {
        return new Ops.Reducer<T>(){

            @Override
            public T op(T a, T b) {
                return a != null && (b == null || a.compareTo(b) <= 0) ? a : b;
            }
        };
    }

    public static <T> Ops.Reducer<T> maxReducer(final Comparator<? super T> comparator) {
        return new Ops.Reducer<T>(){

            @Override
            public T op(T a, T b) {
                return a != null && (b == null || comparator.compare(a, b) >= 0) ? a : b;
            }
        };
    }

    public static <T> Ops.Reducer<T> minReducer(final Comparator<? super T> comparator) {
        return new Ops.Reducer<T>(){

            @Override
            public T op(T a, T b) {
                return a != null && (b == null || comparator.compare(a, b) <= 0) ? a : b;
            }
        };
    }

    public static Comparator<Object> castedComparator() {
        return RawComparator.cmp;
    }

    public static Ops.Reducer<Object> castedMaxReducer() {
        return RawMaxReducer.max;
    }

    public static Ops.Reducer<Object> castedMinReducer() {
        return RawMinReducer.min;
    }

    public static Ops.DoubleComparator naturalDoubleComparator() {
        return NaturalDoubleComparator.comparator;
    }

    public static Ops.DoubleReducer naturalDoubleMaxReducer() {
        return NaturalDoubleMaxReducer.max;
    }

    public static Ops.DoubleReducer naturalDoubleMinReducer() {
        return NaturalDoubleMinReducer.min;
    }

    public static Ops.DoubleReducer doubleMaxReducer(final Ops.DoubleComparator comparator) {
        return new Ops.DoubleReducer(){

            @Override
            public double op(double a, double b) {
                return comparator.compare(a, b) >= 0 ? a : b;
            }
        };
    }

    public static Ops.DoubleReducer doubleMinReducer(final Ops.DoubleComparator comparator) {
        return new Ops.DoubleReducer(){

            @Override
            public double op(double a, double b) {
                return comparator.compare(a, b) <= 0 ? a : b;
            }
        };
    }

    public static Ops.LongComparator naturalLongComparator() {
        return NaturalLongComparator.comparator;
    }

    public static Ops.LongReducer naturalLongMaxReducer() {
        return NaturalLongMaxReducer.max;
    }

    public static Ops.LongReducer naturalLongMinReducer() {
        return NaturalLongMinReducer.min;
    }

    public static Ops.LongReducer longMaxReducer(final Ops.LongComparator comparator) {
        return new Ops.LongReducer(){

            @Override
            public long op(long a, long b) {
                return comparator.compare(a, b) >= 0 ? a : b;
            }
        };
    }

    public static Ops.LongReducer longMinReducer(final Ops.LongComparator comparator) {
        return new Ops.LongReducer(){

            @Override
            public long op(long a, long b) {
                return comparator.compare(a, b) <= 0 ? a : b;
            }
        };
    }

    public static <T, U, V> Ops.Op<T, V> compoundOp(final Ops.Op<? super T, ? extends U> first, final Ops.Op<? super U, ? extends V> second) {
        return new Ops.Op<T, V>(){

            @Override
            public final V op(T t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T, V> Ops.Op<T, V> compoundOp(final Ops.ObjectToDouble<? super T> first, final Ops.DoubleToObject<? extends V> second) {
        return new Ops.Op<T, V>(){

            @Override
            public final V op(T t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T, V> Ops.Op<T, V> compoundOp(final Ops.ObjectToLong<? super T> first, final Ops.LongToObject<? extends V> second) {
        return new Ops.Op<T, V>(){

            @Override
            public final V op(T t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T, V> Ops.DoubleToObject<V> compoundOp(final Ops.DoubleToObject<? extends T> first, final Ops.Op<? super T, ? extends V> second) {
        return new Ops.DoubleToObject<V>(){

            @Override
            public final V op(double t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T, V> Ops.LongToObject<V> compoundOp(final Ops.LongToObject<? extends T> first, final Ops.Op<? super T, ? extends V> second) {
        return new Ops.LongToObject<V>(){

            @Override
            public final V op(long t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T, U> Ops.ObjectToDouble<T> compoundOp(final Ops.Op<? super T, ? extends U> first, final Ops.ObjectToDouble<? super U> second) {
        return new Ops.ObjectToDouble<T>(){

            @Override
            public final double op(T t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T, U> Ops.ObjectToLong<T> compoundOp(final Ops.Op<? super T, ? extends U> first, final Ops.ObjectToLong<? super U> second) {
        return new Ops.ObjectToLong<T>(){

            @Override
            public final long op(T t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.ObjectToDouble<T> compoundOp(final Ops.ObjectToDouble<? super T> first, final Ops.DoubleOp second) {
        return new Ops.ObjectToDouble<T>(){

            @Override
            public final double op(T t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.ObjectToLong<T> compoundOp(final Ops.ObjectToDouble<? super T> first, final Ops.DoubleToLong second) {
        return new Ops.ObjectToLong<T>(){

            @Override
            public final long op(T t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.ObjectToLong<T> compoundOp(final Ops.ObjectToLong<? super T> first, final Ops.LongOp second) {
        return new Ops.ObjectToLong<T>(){

            @Override
            public final long op(T t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.ObjectToDouble<T> compoundOp(final Ops.ObjectToLong<? super T> first, final Ops.LongToDouble second) {
        return new Ops.ObjectToDouble<T>(){

            @Override
            public final double op(T t) {
                return second.op(first.op(t));
            }
        };
    }

    public static Ops.DoubleOp compoundOp(final Ops.DoubleOp first, final Ops.DoubleOp second) {
        return new Ops.DoubleOp(){

            @Override
            public final double op(double t) {
                return second.op(first.op(t));
            }
        };
    }

    public static Ops.DoubleToLong compoundOp(final Ops.DoubleOp first, final Ops.DoubleToLong second) {
        return new Ops.DoubleToLong(){

            @Override
            public final long op(double t) {
                return second.op(first.op(t));
            }
        };
    }

    public static Ops.DoubleToLong compoundOp(final Ops.DoubleToLong first, final Ops.LongOp second) {
        return new Ops.DoubleToLong(){

            @Override
            public final long op(double t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.DoubleToObject<T> compoundOp(final Ops.DoubleToLong first, final Ops.LongToObject<? extends T> second) {
        return new Ops.DoubleToObject<T>(){

            @Override
            public final T op(double t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.LongToObject<T> compoundOp(final Ops.LongToDouble first, final Ops.DoubleToObject<? extends T> second) {
        return new Ops.LongToObject<T>(){

            @Override
            public final T op(long t) {
                return second.op(first.op(t));
            }
        };
    }

    public static Ops.LongToDouble compoundOp(final Ops.LongOp first, final Ops.LongToDouble second) {
        return new Ops.LongToDouble(){

            @Override
            public final double op(long t) {
                return second.op(first.op(t));
            }
        };
    }

    public static Ops.LongToDouble compoundOp(final Ops.LongToDouble first, final Ops.DoubleOp second) {
        return new Ops.LongToDouble(){

            @Override
            public final double op(long t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.DoubleToObject<T> compoundOp(final Ops.DoubleOp first, final Ops.DoubleToObject<? extends T> second) {
        return new Ops.DoubleToObject<T>(){

            @Override
            public final T op(double t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.LongToObject<T> compoundOp(final Ops.LongOp first, final Ops.LongToObject<? extends T> second) {
        return new Ops.LongToObject<T>(){

            @Override
            public final T op(long t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.DoubleOp compoundOp(final Ops.DoubleToObject<? extends T> first, final Ops.ObjectToDouble<? super T> second) {
        return new Ops.DoubleOp(){

            @Override
            public final double op(double t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.LongToDouble compoundOp(final Ops.LongToObject<? extends T> first, final Ops.ObjectToDouble<? super T> second) {
        return new Ops.LongToDouble(){

            @Override
            public final double op(long t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.DoubleToLong compoundOp(final Ops.DoubleToObject<? extends T> first, final Ops.ObjectToLong<? super T> second) {
        return new Ops.DoubleToLong(){

            @Override
            public final long op(double t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.LongOp compoundOp(final Ops.LongToObject<? extends T> first, final Ops.ObjectToLong<? super T> second) {
        return new Ops.LongOp(){

            @Override
            public final long op(long t) {
                return second.op(first.op(t));
            }
        };
    }

    public static Ops.LongOp compoundOp(final Ops.LongOp first, final Ops.LongOp second) {
        return new Ops.LongOp(){

            @Override
            public final long op(long t) {
                return second.op(first.op(t));
            }
        };
    }

    public static Ops.DoubleOp compoundOp(final Ops.DoubleToLong first, final Ops.LongToDouble second) {
        return new Ops.DoubleOp(){

            @Override
            public final double op(double t) {
                return second.op(first.op(t));
            }
        };
    }

    public static Ops.LongOp compoundOp(final Ops.LongToDouble first, final Ops.DoubleToLong second) {
        return new Ops.LongOp(){

            @Override
            public final long op(long t) {
                return second.op(first.op(t));
            }
        };
    }

    public static <T> Ops.Predicate<T> notPredicate(final Ops.Predicate<T> pred) {
        return new Ops.Predicate<T>(){

            @Override
            public final boolean op(T x) {
                return !pred.op(x);
            }
        };
    }

    public static Ops.DoublePredicate notPredicate(final Ops.DoublePredicate pred) {
        return new Ops.DoublePredicate(){

            @Override
            public final boolean op(double x) {
                return !pred.op(x);
            }
        };
    }

    public static Ops.LongPredicate notPredicate(final Ops.LongPredicate pred) {
        return new Ops.LongPredicate(){

            @Override
            public final boolean op(long x) {
                return !pred.op(x);
            }
        };
    }

    public static <S, T extends S> Ops.Predicate<T> andPredicate(final Ops.Predicate<S> first, final Ops.Predicate<? super T> second) {
        return new Ops.Predicate<T>(){

            @Override
            public final boolean op(T x) {
                return first.op(x) && second.op(x);
            }
        };
    }

    public static <S, T extends S> Ops.Predicate<T> orPredicate(final Ops.Predicate<S> first, final Ops.Predicate<? super T> second) {
        return new Ops.Predicate<T>(){

            @Override
            public final boolean op(T x) {
                return first.op(x) || second.op(x);
            }
        };
    }

    public static Ops.DoublePredicate andPredicate(final Ops.DoublePredicate first, final Ops.DoublePredicate second) {
        return new Ops.DoublePredicate(){

            @Override
            public final boolean op(double x) {
                return first.op(x) && second.op(x);
            }
        };
    }

    public static Ops.DoublePredicate orPredicate(final Ops.DoublePredicate first, final Ops.DoublePredicate second) {
        return new Ops.DoublePredicate(){

            @Override
            public final boolean op(double x) {
                return first.op(x) || second.op(x);
            }
        };
    }

    public static Ops.LongPredicate andPredicate(final Ops.LongPredicate first, final Ops.LongPredicate second) {
        return new Ops.LongPredicate(){

            @Override
            public final boolean op(long x) {
                return first.op(x) && second.op(x);
            }
        };
    }

    public static Ops.LongPredicate orPredicate(final Ops.LongPredicate first, final Ops.LongPredicate second) {
        return new Ops.LongPredicate(){

            @Override
            public final boolean op(long x) {
                return first.op(x) || second.op(x);
            }
        };
    }

    public static Ops.Predicate<Object> isNonNullPredicate() {
        return IsNonNullPredicate.predicate;
    }

    public static Ops.Predicate<Object> isNullPredicate() {
        return IsNullPredicate.predicate;
    }

    public static Ops.Predicate<Object> instanceofPredicate(final Class type) {
        return new Ops.Predicate<Object>(){

            @Override
            public final boolean op(Object x) {
                return type.isInstance(x);
            }
        };
    }

    public static Ops.Predicate<Object> isAssignablePredicate(final Class type) {
        return new Ops.Predicate<Object>(){

            @Override
            public final boolean op(Object x) {
                return type.isAssignableFrom(x.getClass());
            }
        };
    }

    public static Ops.DoubleReducer doubleAdder() {
        return DoubleAdder.adder;
    }

    public static Ops.LongReducer longAdder() {
        return LongAdder.adder;
    }

    public static Ops.IntReducer intAdder() {
        return IntAdder.adder;
    }

    public static Ops.DoubleGenerator doubleRandom() {
        return DoubleRandomGenerator.generator;
    }

    public static Ops.DoubleGenerator doubleRandom(double bound) {
        return new DoubleBoundedRandomGenerator(bound);
    }

    public static Ops.DoubleGenerator doubleRandom(double least, double bound) {
        return new DoubleIntervalRandomGenerator(least, bound);
    }

    public static Ops.LongGenerator longRandom() {
        return LongRandomGenerator.generator;
    }

    public static Ops.LongGenerator longRandom(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException();
        }
        return new LongBoundedRandomGenerator(bound);
    }

    public static Ops.LongGenerator longRandom(long least, long bound) {
        if (least >= bound) {
            throw new IllegalArgumentException();
        }
        return new LongIntervalRandomGenerator(least, bound);
    }

    public static Ops.IntGenerator intRandom() {
        return IntRandomGenerator.generator;
    }

    public static Ops.IntGenerator intRandom(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException();
        }
        return new IntBoundedRandomGenerator(bound);
    }

    public static Ops.IntGenerator intRandom(int least, int bound) {
        if (least >= bound) {
            throw new IllegalArgumentException();
        }
        return new IntIntervalRandomGenerator(least, bound);
    }

    public static Ops.BinaryPredicate<Object, Object> equalityPredicate() {
        return EqualityPredicate.predicate;
    }

    public static Ops.BinaryPredicate<Object, Object> identityPredicate() {
        return IdentityPredicate.predicate;
    }

    public static Ops.BinaryIntPredicate intEqualityPredicate() {
        return IntEqualityPredicate.predicate;
    }

    public static Ops.BinaryLongPredicate longEqualityPredicate() {
        return LongEqualityPredicate.predicate;
    }

    public static Ops.BinaryDoublePredicate doubleEqualityPredicate() {
        return DoubleEqualityPredicate.predicate;
    }

    public static Ops.BinaryPredicate<Object, Object> inequalityPredicate() {
        return InequalityPredicate.predicate;
    }

    public static Ops.BinaryPredicate<Object, Object> nonidentityPredicate() {
        return NonidentityPredicate.predicate;
    }

    public static Ops.BinaryIntPredicate intInequalityPredicate() {
        return IntInequalityPredicate.predicate;
    }

    public static Ops.BinaryLongPredicate longInequalityPredicate() {
        return LongInequalityPredicate.predicate;
    }

    public static Ops.BinaryDoublePredicate doubleInequalityPredicate() {
        return DoubleInequalityPredicate.predicate;
    }

    static final class DoubleInequalityPredicate
    implements Ops.BinaryDoublePredicate {
        static final DoubleInequalityPredicate predicate = new DoubleInequalityPredicate();

        DoubleInequalityPredicate() {
        }

        @Override
        public final boolean op(double x, double y) {
            return x != y;
        }
    }

    static final class LongInequalityPredicate
    implements Ops.BinaryLongPredicate {
        static final LongInequalityPredicate predicate = new LongInequalityPredicate();

        LongInequalityPredicate() {
        }

        @Override
        public final boolean op(long x, long y) {
            return x != y;
        }
    }

    static final class IntInequalityPredicate
    implements Ops.BinaryIntPredicate {
        static final IntInequalityPredicate predicate = new IntInequalityPredicate();

        IntInequalityPredicate() {
        }

        @Override
        public final boolean op(int x, int y) {
            return x != y;
        }
    }

    static final class NonidentityPredicate
    implements Ops.BinaryPredicate<Object, Object> {
        static final NonidentityPredicate predicate = new NonidentityPredicate();

        NonidentityPredicate() {
        }

        @Override
        public final boolean op(Object x, Object y) {
            return x != y;
        }
    }

    static final class InequalityPredicate
    implements Ops.BinaryPredicate<Object, Object> {
        static final InequalityPredicate predicate = new InequalityPredicate();

        InequalityPredicate() {
        }

        @Override
        public final boolean op(Object x, Object y) {
            return !x.equals(y);
        }
    }

    static final class DoubleEqualityPredicate
    implements Ops.BinaryDoublePredicate {
        static final DoubleEqualityPredicate predicate = new DoubleEqualityPredicate();

        DoubleEqualityPredicate() {
        }

        @Override
        public final boolean op(double x, double y) {
            return x == y;
        }
    }

    static final class LongEqualityPredicate
    implements Ops.BinaryLongPredicate {
        static final LongEqualityPredicate predicate = new LongEqualityPredicate();

        LongEqualityPredicate() {
        }

        @Override
        public final boolean op(long x, long y) {
            return x == y;
        }
    }

    static final class IntEqualityPredicate
    implements Ops.BinaryIntPredicate {
        static final IntEqualityPredicate predicate = new IntEqualityPredicate();

        IntEqualityPredicate() {
        }

        @Override
        public final boolean op(int x, int y) {
            return x == y;
        }
    }

    static final class IdentityPredicate
    implements Ops.BinaryPredicate<Object, Object> {
        static final IdentityPredicate predicate = new IdentityPredicate();

        IdentityPredicate() {
        }

        @Override
        public final boolean op(Object x, Object y) {
            return x == y;
        }
    }

    static final class EqualityPredicate
    implements Ops.BinaryPredicate<Object, Object> {
        static final EqualityPredicate predicate = new EqualityPredicate();

        EqualityPredicate() {
        }

        @Override
        public final boolean op(Object x, Object y) {
            return x.equals(y);
        }
    }

    static final class IntIntervalRandomGenerator
    implements Ops.IntGenerator {
        final int least;
        final int range;

        IntIntervalRandomGenerator(int least, int bound) {
            this.least = least;
            this.range = bound - least;
        }

        @Override
        public int op() {
            return ThreadLocalRandom.current().nextInt(this.range) + this.least;
        }
    }

    static final class IntBoundedRandomGenerator
    implements Ops.IntGenerator {
        final int bound;

        IntBoundedRandomGenerator(int bound) {
            this.bound = bound;
        }

        @Override
        public int op() {
            return ThreadLocalRandom.current().nextInt(this.bound);
        }
    }

    static final class IntRandomGenerator
    implements Ops.IntGenerator {
        static final IntRandomGenerator generator = new IntRandomGenerator();

        IntRandomGenerator() {
        }

        @Override
        public int op() {
            return ThreadLocalRandom.current().nextInt();
        }
    }

    static final class LongIntervalRandomGenerator
    implements Ops.LongGenerator {
        final long least;
        final long range;

        LongIntervalRandomGenerator(long least, long bound) {
            this.least = least;
            this.range = bound - least;
        }

        @Override
        public long op() {
            return ThreadLocalRandom.current().nextLong(this.range) + this.least;
        }
    }

    static final class LongBoundedRandomGenerator
    implements Ops.LongGenerator {
        final long bound;

        LongBoundedRandomGenerator(long bound) {
            this.bound = bound;
        }

        @Override
        public long op() {
            return ThreadLocalRandom.current().nextLong(this.bound);
        }
    }

    static final class LongRandomGenerator
    implements Ops.LongGenerator {
        static final LongRandomGenerator generator = new LongRandomGenerator();

        LongRandomGenerator() {
        }

        @Override
        public long op() {
            return ThreadLocalRandom.current().nextLong();
        }
    }

    static final class DoubleIntervalRandomGenerator
    implements Ops.DoubleGenerator {
        final double least;
        final double range;

        DoubleIntervalRandomGenerator(double least, double bound) {
            this.least = least;
            this.range = bound - least;
        }

        @Override
        public double op() {
            return ThreadLocalRandom.current().nextDouble() * this.range + this.least;
        }
    }

    static final class DoubleBoundedRandomGenerator
    implements Ops.DoubleGenerator {
        final double bound;

        DoubleBoundedRandomGenerator(double bound) {
            this.bound = bound;
        }

        @Override
        public double op() {
            return ThreadLocalRandom.current().nextDouble() * this.bound;
        }
    }

    static final class DoubleRandomGenerator
    implements Ops.DoubleGenerator {
        static final DoubleRandomGenerator generator = new DoubleRandomGenerator();

        DoubleRandomGenerator() {
        }

        @Override
        public double op() {
            return ThreadLocalRandom.current().nextDouble();
        }
    }

    static final class IntAdder
    implements Ops.IntReducer {
        static final IntAdder adder = new IntAdder();

        IntAdder() {
        }

        @Override
        public int op(int a, int b) {
            return a + b;
        }
    }

    static final class LongAdder
    implements Ops.LongReducer {
        static final LongAdder adder = new LongAdder();

        LongAdder() {
        }

        @Override
        public long op(long a, long b) {
            return a + b;
        }
    }

    static final class DoubleAdder
    implements Ops.DoubleReducer {
        static final DoubleAdder adder = new DoubleAdder();

        DoubleAdder() {
        }

        @Override
        public double op(double a, double b) {
            return a + b;
        }
    }

    static final class IsNullPredicate
    implements Ops.Predicate<Object> {
        static final IsNullPredicate predicate = new IsNullPredicate();

        IsNullPredicate() {
        }

        @Override
        public final boolean op(Object x) {
            return x != null;
        }
    }

    static final class IsNonNullPredicate
    implements Ops.Predicate<Object> {
        static final IsNonNullPredicate predicate = new IsNonNullPredicate();

        IsNonNullPredicate() {
        }

        @Override
        public final boolean op(Object x) {
            return x != null;
        }
    }

    static final class NaturalLongMinReducer
    implements Ops.LongReducer {
        public static final NaturalLongMinReducer min = new NaturalLongMinReducer();

        NaturalLongMinReducer() {
        }

        @Override
        public long op(long a, long b) {
            return a <= b ? a : b;
        }
    }

    static final class NaturalLongMaxReducer
    implements Ops.LongReducer {
        public static final NaturalLongMaxReducer max = new NaturalLongMaxReducer();

        NaturalLongMaxReducer() {
        }

        @Override
        public long op(long a, long b) {
            return a >= b ? a : b;
        }
    }

    static final class NaturalLongComparator
    implements Ops.LongComparator {
        static final NaturalLongComparator comparator = new NaturalLongComparator();

        NaturalLongComparator() {
        }

        @Override
        public int compare(long a, long b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    }

    static final class NaturalDoubleMinReducer
    implements Ops.DoubleReducer {
        public static final NaturalDoubleMinReducer min = new NaturalDoubleMinReducer();

        NaturalDoubleMinReducer() {
        }

        @Override
        public double op(double a, double b) {
            return Math.min(a, b);
        }
    }

    static final class NaturalDoubleMaxReducer
    implements Ops.DoubleReducer {
        public static final NaturalDoubleMaxReducer max = new NaturalDoubleMaxReducer();

        NaturalDoubleMaxReducer() {
        }

        @Override
        public double op(double a, double b) {
            return Math.max(a, b);
        }
    }

    static final class NaturalDoubleComparator
    implements Ops.DoubleComparator {
        static final NaturalDoubleComparator comparator = new NaturalDoubleComparator();

        NaturalDoubleComparator() {
        }

        @Override
        public int compare(double a, double b) {
            return Double.compare(a, b);
        }
    }

    static final class RawMinReducer
    implements Ops.Reducer {
        static final RawMinReducer min = new RawMinReducer();

        RawMinReducer() {
        }

        @Override
        public Object op(Object a, Object b) {
            return a != null && (b == null || ((Comparable)a).compareTo((Comparable)b) <= 0) ? a : b;
        }
    }

    static final class RawMaxReducer
    implements Ops.Reducer {
        static final RawMaxReducer max = new RawMaxReducer();

        RawMaxReducer() {
        }

        @Override
        public Object op(Object a, Object b) {
            return a != null && (b == null || ((Comparable)a).compareTo((Comparable)b) >= 0) ? a : b;
        }
    }

    static final class RawComparator
    implements Comparator {
        static final RawComparator cmp = new RawComparator();

        RawComparator() {
        }

        public int compare(Object a, Object b) {
            return ((Comparable)a).compareTo((Comparable)b);
        }
    }
}

