/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyRequest;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyResponse;
import org.apache.directory.api.ldap.extras.extended.pwdModify.PasswordModifyResponseImpl;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.shared.DefaultCoreSession;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PwdModifyHandler
implements ExtendedOperationHandler<PasswordModifyRequest, PasswordModifyResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(PwdModifyHandler.class);
    public static final Set<String> EXTENSION_OIDS;

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.4203.1.11.1";
    }

    private void modifyUserPassword(CoreSession userSession, Entry userEntry, Dn userDn, byte[] oldPassword, byte[] newPassword, PasswordModifyRequest req) {
        IoSession ioSession = ((DefaultCoreSession)userSession).getIoSession();
        if (newPassword == null) {
            this.writeResult(ioSession, req, ResultCodeEnum.UNWILLING_TO_PERFORM, "Cannot change a password for user " + userDn + ", exception : null new password");
            return;
        }
        Attribute userPassword = userEntry.get("userPassword");
        if (userPassword == null) {
            this.writeResult(ioSession, req, ResultCodeEnum.UNWILLING_TO_PERFORM, "Cannot change a password for user " + userDn + ", the user has no existing password");
            return;
        }
        if (userPassword.contains((byte[][])new byte[][]{newPassword})) {
            PasswordModifyResponseImpl pmrl = new PasswordModifyResponseImpl(req.getMessageId(), ResultCodeEnum.SUCCESS);
            Control ppolicyControl = req.getControl("1.3.6.1.4.1.42.2.27.8.5.1");
            if (ppolicyControl != null) {
                pmrl.addControl(ppolicyControl);
            }
            ioSession.write((Object)pmrl);
            return;
        }
        if (oldPassword == null) {
            ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
            modifyRequest.setName(userDn);
            Control ppolicyControl = req.getControl("1.3.6.1.4.1.42.2.27.8.5.1");
            if (ppolicyControl != null) {
                modifyRequest.addControl(ppolicyControl);
            }
            try {
                DefaultModification modification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, userPassword.getAttributeType(), (byte[][])new byte[][]{newPassword});
                modifyRequest.addModification((Modification)modification);
                ResultCodeEnum errorCode = null;
                String errorMessage = null;
                try {
                    userSession.modify((ModifyRequest)modifyRequest);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Password modified for user {}", (Object)userDn);
                    }
                    PasswordModifyResponseImpl pmrl = new PasswordModifyResponseImpl(req.getMessageId(), ResultCodeEnum.SUCCESS);
                    ppolicyControl = modifyRequest.getResultResponse().getControl("1.3.6.1.4.1.42.2.27.8.5.1");
                    if (ppolicyControl != null) {
                        pmrl.addControl(ppolicyControl);
                    }
                    ioSession.write((Object)pmrl);
                    return;
                }
                catch (LdapOperationException loe) {
                    errorCode = loe.getResultCode();
                    errorMessage = loe.getMessage();
                }
                catch (LdapException le) {
                    errorCode = ResultCodeEnum.OTHER;
                    errorMessage = le.getMessage();
                }
                LOG.error("Cannot modify the password for user {}, exception : {}", (Object)userDn, (Object)errorMessage);
                PasswordModifyResponseImpl errorPmrl = new PasswordModifyResponseImpl(req.getMessageId(), errorCode, "Cannot modify the password for user " + userDn + ", exception : " + errorMessage);
                ppolicyControl = modifyRequest.getResultResponse().getControl("1.3.6.1.4.1.42.2.27.8.5.1");
                if (ppolicyControl != null) {
                    errorPmrl.addControl(ppolicyControl);
                }
                ioSession.write((Object)errorPmrl);
                return;
            }
            catch (LdapInvalidAttributeValueException modification) {}
        } else {
            boolean valid = false;
            DefaultAttribute modifiedPassword = new DefaultAttribute(userPassword.getAttributeType());
            for (Value value : userPassword) {
                if (!valid) {
                    valid = PasswordUtil.compareCredentials((byte[])oldPassword, (byte[])value.getBytes());
                }
                try {
                    if (valid) {
                        modifiedPassword.add((byte[][])new byte[][]{newPassword});
                        continue;
                    }
                    modifiedPassword.add(new Value[]{value});
                }
                catch (LdapInvalidAttributeValueException errorMessage) {}
            }
            if (valid) {
                ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
                modifyRequest.setName(userDn);
                Control ppolicyControl = req.getControl("1.3.6.1.4.1.42.2.27.8.5.1");
                if (ppolicyControl != null) {
                    modifyRequest.addControl(ppolicyControl);
                }
                DefaultModification modification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)modifiedPassword);
                modifyRequest.addModification((Modification)modification);
                ResultCodeEnum errorCode = null;
                String errorMessage = null;
                try {
                    userSession.modify((ModifyRequest)modifyRequest);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Password modified for user {}", (Object)userDn);
                    }
                    PasswordModifyResponseImpl pmrl = new PasswordModifyResponseImpl(req.getMessageId(), ResultCodeEnum.SUCCESS);
                    ppolicyControl = modifyRequest.getResultResponse().getControl("1.3.6.1.4.1.42.2.27.8.5.1");
                    if (ppolicyControl != null) {
                        pmrl.addControl(ppolicyControl);
                    }
                    ioSession.write((Object)pmrl);
                    return;
                }
                catch (LdapOperationException loe) {
                    errorCode = loe.getResultCode();
                    errorMessage = loe.getMessage();
                }
                catch (LdapException le) {
                    errorCode = ResultCodeEnum.OTHER;
                    errorMessage = le.getMessage();
                }
                LOG.error("Cannot modify the password for user {}, exception : {}", (Object)userDn, (Object)errorMessage);
                PasswordModifyResponseImpl errorPmrl = new PasswordModifyResponseImpl(req.getMessageId(), errorCode, "Cannot modify the password for user " + userDn + ", exception : " + errorMessage);
                ppolicyControl = modifyRequest.getResultResponse().getControl("1.3.6.1.4.1.42.2.27.8.5.1");
                if (ppolicyControl != null) {
                    errorPmrl.addControl(ppolicyControl);
                }
                ioSession.write((Object)errorPmrl);
                return;
            }
            this.writeResult(ioSession, req, ResultCodeEnum.INVALID_CREDENTIALS, "Cannot change a password for user " + userDn + ", invalid credentials");
            return;
        }
    }

    private void writeResult(LdapSession requestor, PasswordModifyRequest req, ResultCodeEnum error, String errorMessage) {
        this.writeResult(requestor.getIoSession(), req, error, errorMessage);
    }

    private void writeResult(IoSession ioSession, PasswordModifyRequest req, ResultCodeEnum error, String errorMessage) {
        LOG.error(errorMessage);
        ioSession.write((Object)new PasswordModifyResponseImpl(req.getMessageId(), error, errorMessage));
    }

    private Entry getModifiedEntry(LdapSession requestor, PasswordModifyRequest req, Dn entryDn) {
        try {
            Entry modifiedEntry = requestor.getCoreSession().lookup(entryDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            if (modifiedEntry == null) {
                this.writeResult(requestor, req, ResultCodeEnum.NO_SUCH_OBJECT, "The entry does not exist, we can't modify its password");
                return null;
            }
            return modifiedEntry;
        }
        catch (Exception le) {
            this.writeResult(requestor, req, ResultCodeEnum.NO_SUCH_OBJECT, "The entry does not exist, we can't modify its password");
            return null;
        }
    }

    private void processAuthenticatedPasswordModify(LdapSession requestor, PasswordModifyRequest req, Dn userDn) {
        byte[] oldPassword = req.getOldPassword();
        byte[] newPassword = req.getNewPassword();
        Entry modifiedEntry = null;
        Dn principalDn = requestor.getCoreSession().getEffectivePrincipal().getDn();
        LOG.debug("User {} trying to modify password of user {}", (Object)principalDn, (Object)userDn);
        if (userDn != null && !userDn.equals((Object)principalDn)) {
            if (requestor.getCoreSession().isAdministrator()) {
                modifiedEntry = this.getModifiedEntry(requestor, req, userDn);
                if (modifiedEntry == null) {
                    return;
                }
                this.modifyUserPassword(requestor.getCoreSession(), modifiedEntry, userDn, oldPassword, newPassword, req);
            } else {
                this.writeResult(requestor, req, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS, "Non-admin user cannot access another user's password to modify it");
            }
        } else {
            modifiedEntry = this.getModifiedEntry(requestor, req, principalDn);
            if (modifiedEntry == null) {
                return;
            }
            this.modifyUserPassword(requestor.getCoreSession(), modifiedEntry, principalDn, oldPassword, newPassword, req);
        }
    }

    @Override
    public void handleExtendedOperation(LdapSession requestor, PasswordModifyRequest req) throws Exception {
        LOG.debug("Password modification requested");
        DirectoryService service = requestor.getLdapServer().getDirectoryService();
        CoreSession adminSession = service.getAdminSession();
        String userIdentity = Strings.utf8ToString((byte[])req.getUserIdentity());
        Dn userDn = null;
        if (!Strings.isEmpty((String)userIdentity)) {
            try {
                userDn = service.getDnFactory().create(userIdentity);
            }
            catch (LdapInvalidDnException lide) {
                this.writeResult(requestor, req, ResultCodeEnum.INVALID_DN_SYNTAX, "The user DN is invalid : " + userDn);
                return;
            }
        }
        byte[] oldPassword = req.getOldPassword();
        byte[] newPassword = req.getNewPassword();
        if (requestor.isAuthenticated()) {
            this.processAuthenticatedPasswordModify(requestor, req, userDn);
        } else {
            BindOperationContext bindContext = new BindOperationContext(adminSession);
            bindContext.setDn(userDn);
            bindContext.setCredentials(oldPassword);
            try {
                service.getOperationManager().bind(bindContext);
            }
            catch (LdapException le) {
                requestor.getIoSession().write((Object)new PasswordModifyResponseImpl(req.getMessageId(), ResultCodeEnum.INVALID_CREDENTIALS));
                return;
            }
            this.modifyUserPassword(requestor.getCoreSession(), bindContext.getEntry(), userDn, oldPassword, newPassword, req);
        }
    }

    @Override
    public Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
    }

    static {
        HashSet<String> set = new HashSet<String>(2);
        set.add("1.3.6.1.4.1.4203.1.11.1");
        set.add("1.3.6.1.4.1.4203.1.11.1");
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

