/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.CodeGenUtils;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.JSDescriptor;
import org.mozilla.javascript.JSFunction;
import org.mozilla.javascript.JSScript;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFn;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.ast.TemplateCharacters;
import org.mozilla.javascript.optimizer.BodyCodegen;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptJSCode;
import org.mozilla.javascript.optimizer.OptJSFunctionCode;
import org.mozilla.javascript.optimizer.OptJSScriptCode;
import org.mozilla.javascript.optimizer.OptTransformer;
import org.mozilla.javascript.optimizer.Optimizer;

public class Codegen
implements Evaluator {
    static final String DEFAULT_MAIN_METHOD_CLASS = "org.mozilla.javascript.optimizer.OptRuntime";
    private static final String SUPER_CLASS_NAME = "java.lang.Object";
    static final String ID_FIELD_NAME = "_id";
    static final String DESCRIPTOR_CLASS_SIGNATURE = "Lorg/mozilla/javascript/JSDescriptor;";
    static final String DESCRIPTORS_FIELD_NAME = "_descriptors";
    static final String DESCRIPTORS_FIELD_SIGNATURE = "[Lorg/mozilla/javascript/JSDescriptor;";
    static final String REGEXP_INIT_METHOD_NAME = "_reInit";
    static final String REGEXP_INIT_METHOD_SIGNATURE = "(Lorg/mozilla/javascript/Context;)V";
    static final String TEMPLATE_LITERAL_INIT_METHOD_NAME = "_qInit";
    static final String TEMPLATE_LITERAL_INIT_METHOD_SIGNATURE = "()V";
    static final String CODE_INIT_SIGNATURE = "(Lorg/mozilla/javascript/Context;)V";
    static final String CODE_CONSTRUCTOR_SIGNATURE = "(Lorg/mozilla/javascript/Context;I)V";
    static final String JSFUNCTION_CLASS_NAME = "org.mozilla.javascript.JSFunction";
    static final String JSFUNCTION_CLASS_SIGNATURE = "org/mozilla/javascript/JSFunction";
    static final String JSFUNCTION_CONSTRUCTOR_SIGNATURE = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/JSDescriptor;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)V";
    static final String GENERATOR_METHOD_SIGNATURE = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/JSFunction;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;ILjava/lang/Object;)Ljava/lang/Object;";
    private static final Object globalLock = new Object();
    private static int globalSerialClassCounter;
    private CompilerEnvirons compilerEnv;
    private List<OptFunctionNode> directCallTargets;
    ScriptNode[] scriptOrFnNodes;
    JSDescriptor.Builder[] builders;
    private HashMap<ScriptNode, Integer> scriptOrFnIndexes;
    private String mainMethodClass = "org.mozilla.javascript.optimizer.OptRuntime";
    String mainClassName;
    String mainClassSignature;
    private double[] itsConstantList;
    private int itsConstantListSize;

    @Override
    public void captureStackInfo(RhinoException ex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSourcePositionFromStack(Context cx, int[] linep) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPatchedStack(RhinoException ex, String nativeStackTrace) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getScriptStack(RhinoException ex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEvalScriptFlag(Script script) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object compile(CompilerEnvirons compilerEnv, ScriptNode tree, String rawSource, boolean returnFunction) {
        int serial;
        Object object = globalLock;
        synchronized (object) {
            serial = ++globalSerialClassCounter;
        }
        Object baseName = "c";
        if (tree.getSourceName().length() > 0 && !Character.isJavaIdentifierStart(((String)(baseName = tree.getSourceName().replaceAll("\\W", "_"))).charAt(0))) {
            baseName = "_" + (String)baseName;
        }
        String mainClassName = "org.mozilla.javascript.gen." + (String)baseName + "_" + serial;
        JSDescriptor.Builder builder = new JSDescriptor.Builder();
        OptJSCode.BuilderEnv builderEnv = new OptJSCode.BuilderEnv(mainClassName);
        byte[] mainClassBytes = this.compileToClassFile(compilerEnv, builder, builderEnv, mainClassName, tree, rawSource, returnFunction);
        return new CompilationResult(builder, mainClassName, mainClassBytes, builderEnv);
    }

    @Override
    public Script createScriptObject(Object bytecode, Object staticSecurityDomain) {
        JSDescriptor<JSScript> desc = this.defineClass((CompilationResult)bytecode, staticSecurityDomain);
        return JSFunction.createScript(desc, null, staticSecurityDomain);
    }

    @Override
    public Function createFunctionObject(Context cx, Scriptable scope, Object bytecode, Object staticSecurityDomain) {
        JSDescriptor<JSFunction> desc = this.defineClass((CompilationResult)bytecode, staticSecurityDomain);
        return JSFunction.createFunction(cx, scope, desc, null, staticSecurityDomain);
    }

    private <T extends ScriptOrFn<T>> JSDescriptor<T> defineClass(CompilationResult<T> compiled, Object staticSecurityDomain) {
        Exception e;
        ClassLoader rhinoLoader = this.getClass().getClassLoader();
        GeneratedClassLoader loader = SecurityController.createLoader(rhinoLoader, staticSecurityDomain);
        try {
            Class<?> cl = loader.defineClass(compiled.className, compiled.bytecode);
            loader.linkClass(cl);
            compiled.builderEnv.compiledClass = cl;
            ArrayList descs = new ArrayList();
            JSDescriptor desc = compiled.builder.build(d -> descs.add(d));
            cl.getField(DESCRIPTORS_FIELD_NAME).set(null, descs.toArray(new JSDescriptor[0]));
            if (compiled.builderEnv.hasRegExpLiterals) {
                cl.getMethod(REGEXP_INIT_METHOD_NAME, Context.class).invoke(null, Context.getCurrentContext());
            }
            if (compiled.builderEnv.hasTemplateLiterals) {
                cl.getMethod(TEMPLATE_LITERAL_INIT_METHOD_NAME, new Class[0]).invoke(null, new Object[0]);
            }
            return desc;
        }
        catch (InvocationTargetException x) {
            Throwable cause = x.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            e = x;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException x) {
            e = x;
        }
        throw new RuntimeException(e);
    }

    public byte[] compileToClassFile(CompilerEnvirons compilerEnv, JSDescriptor.Builder<?> builder, OptJSCode.BuilderEnv builderEnv, String mainClassName, ScriptNode scriptOrFn, String rawSource, boolean returnFunction) {
        this.compilerEnv = compilerEnv;
        this.transform(scriptOrFn);
        if (Token.printTrees) {
            System.out.println(scriptOrFn.toStringTree(scriptOrFn));
        }
        if (returnFunction) {
            CodeGenUtils.fillInForTopLevelFunction(builder, scriptOrFn.getFunctionNode(0), rawSource, compilerEnv);
            scriptOrFn = scriptOrFn.getFunctionNode(0);
        } else {
            CodeGenUtils.fillInForScript(builder, scriptOrFn, rawSource, compilerEnv);
        }
        this.mainClassName = mainClassName;
        this.mainClassSignature = ClassFileWriter.classNameToSignature(mainClassName);
        this.initScriptNodesData(scriptOrFn, builder, builderEnv);
        return this.generateCode(rawSource);
    }

    private void transform(ScriptNode tree) {
        Codegen.initOptFunctions_r(tree);
        if (this.compilerEnv.isInterpretedMode()) {
            throw new Error();
        }
        HashMap<String, OptFunctionNode> possibleDirectCalls = null;
        if (tree.getType() == 152) {
            int functionCount = tree.getFunctionCount();
            for (int i = 0; i != functionCount; ++i) {
                String name;
                OptFunctionNode ofn = OptFunctionNode.get(tree, i);
                if (ofn.fnode.getFunctionType() != 1 || (name = ofn.fnode.getName()).length() == 0) continue;
                if (possibleDirectCalls == null) {
                    possibleDirectCalls = new HashMap<String, OptFunctionNode>();
                }
                possibleDirectCalls.put(name, ofn);
            }
        }
        if (possibleDirectCalls != null) {
            this.directCallTargets = new ArrayList<OptFunctionNode>();
        }
        OptTransformer ot = new OptTransformer(possibleDirectCalls, this.directCallTargets);
        ot.transform(tree, this.compilerEnv);
        new Optimizer().optimize(tree);
    }

    private static void initOptFunctions_r(ScriptNode scriptOrFn) {
        int N = scriptOrFn.getFunctionCount();
        for (int i = 0; i != N; ++i) {
            FunctionNode fn = scriptOrFn.getFunctionNode(i);
            new OptFunctionNode(fn);
            Codegen.initOptFunctions_r(fn);
        }
    }

    private <U extends ScriptOrFn<U>> void initScriptNodesData(ScriptNode scriptOrFn, JSDescriptor.Builder<U> builder, OptJSCode.BuilderEnv builderEnv) {
        ArrayList<ScriptNode> x = new ArrayList<ScriptNode>();
        ArrayList b = new ArrayList();
        this.collectScriptNodes_r(scriptOrFn, builder, builderEnv, x, b);
        int count = x.size();
        this.scriptOrFnNodes = new ScriptNode[count];
        this.builders = new JSDescriptor.Builder[count];
        this.scriptOrFnNodes = x.toArray(this.scriptOrFnNodes);
        this.builders = b.toArray(this.builders);
        this.scriptOrFnIndexes = new HashMap();
        for (int i = 0; i != count; ++i) {
            this.scriptOrFnIndexes.put(this.scriptOrFnNodes[i], i);
        }
    }

    private <U extends ScriptOrFn<U>> void collectScriptNodes_r(ScriptNode n, JSDescriptor.Builder<U> builder, OptJSCode.BuilderEnv builderEnv, List<ScriptNode> x, List<JSDescriptor.Builder<?>> b) {
        OptJSCode.Builder code = n instanceof FunctionNode ? new OptJSFunctionCode.Builder(builderEnv) : new OptJSScriptCode.Builder(builderEnv);
        code.index = x.size();
        code.methodName = this.getBodyMethodName(n, x.size());
        code.methodType = this.getNonDirectBodyMethodSIgnature(n);
        if (Codegen.isGenerator(n)) {
            code.resumeName = code.methodName + "_gen";
            code.resumeType = GENERATOR_METHOD_SIGNATURE;
        }
        builder.setCode(code);
        builderEnv.hasRegExpLiterals = builderEnv.hasRegExpLiterals | n.getRegexpCount() > 0;
        builderEnv.hasTemplateLiterals = builderEnv.hasTemplateLiterals | n.getTemplateLiteralCount() > 0;
        CodeGenUtils.setConstructor(builder, n);
        x.add(n);
        b.add(builder);
        int nestedCount = n.getFunctionCount();
        for (int i = 0; i != nestedCount; ++i) {
            FunctionNode f = n.getFunctionNode(i);
            JSDescriptor.Builder<JSFunction> fb = builder.createChildBuilder();
            CodeGenUtils.fillInForNestedFunction(fb, builder, f);
            this.collectScriptNodes_r(f, fb, builderEnv, x, b);
        }
    }

    static byte[] generateOptJSCode(String mainClass, String methodName, String methodType, String resumeName, String resumeType, boolean isFunction, int index) {
        String sourceFile = "";
        ClassFileWriter cfw = new ClassFileWriter(mainClass + "ojsc" + Integer.toString(index), isFunction ? "org.mozilla.javascript.optimizer.OptJSFunctionCode" : "org.mozilla.javascript.optimizer.OptJSScriptCode", sourceFile);
        Codegen.generateOptJSCodeCtor(cfw, isFunction);
        Codegen.generateOptJSCodeExecute(cfw, mainClass, methodName, methodType);
        Codegen.generateOptJSCodeResume(cfw, mainClass, resumeName, GENERATOR_METHOD_SIGNATURE);
        return cfw.toByteArray();
    }

    private static void generateOptJSCodeCtor(ClassFileWriter cfw, boolean isFunction) {
        cfw.startMethod("<init>", TEMPLATE_LITERAL_INIT_METHOD_SIGNATURE, (short)1);
        cfw.addALoad(0);
        cfw.addInvoke(183, isFunction ? "org.mozilla.javascript.optimizer.OptJSFunctionCode" : "org.mozilla.javascript.optimizer.OptJSScriptCode", "<init>", TEMPLATE_LITERAL_INIT_METHOD_SIGNATURE);
        cfw.add(177);
        cfw.stopMethod(1);
    }

    private static void generateOptJSCodeExecute(ClassFileWriter cfw, String mainClass, String methodName, String methodType) {
        cfw.startMethod("execute", methodType, (short)17);
        cfw.addALoad(1);
        cfw.addALoad(2);
        cfw.addALoad(3);
        cfw.addALoad(4);
        cfw.addALoad(5);
        cfw.addALoad(6);
        cfw.addInvoke(184, mainClass, methodName, methodType);
        cfw.add(176);
        cfw.stopMethod(7);
    }

    private static void generateOptJSCodeResume(ClassFileWriter cfw, String mainClass, String methodName, String methodType) {
        cfw.startMethod("resume", methodType, (short)17);
        if (methodName == null) {
            cfw.add(1);
        } else {
            cfw.addALoad(1);
            cfw.addALoad(2);
            cfw.addALoad(3);
            cfw.addALoad(4);
            cfw.addILoad(5);
            cfw.addALoad(6);
            cfw.addInvoke(184, mainClass, methodName, methodType);
        }
        cfw.add(176);
        cfw.stopMethod(7);
    }

    private byte[] generateCode(String rawSource) {
        boolean hasScript = this.scriptOrFnNodes[0].getType() == 152;
        boolean hasFunctions = this.scriptOrFnNodes.length > 1 || !hasScript;
        boolean isStrictMode = this.scriptOrFnNodes[0].isInStrictMode();
        String sourceFile = this.scriptOrFnNodes[0].getSourceName();
        ClassFileWriter cfw = new ClassFileWriter(this.mainClassName, SUPER_CLASS_NAME, sourceFile);
        cfw.addField(ID_FIELD_NAME, "I", (short)2);
        cfw.addField(DESCRIPTORS_FIELD_NAME, DESCRIPTORS_FIELD_SIGNATURE, (short)9);
        this.generateLookupAccessor(cfw);
        int count = this.scriptOrFnNodes.length;
        for (int i = 0; i != count; ++i) {
            OptFunctionNode ofn;
            ScriptNode n = this.scriptOrFnNodes[i];
            BodyCodegen bodygen = new BodyCodegen();
            bodygen.cfw = cfw;
            bodygen.codegen = this;
            bodygen.compilerEnv = this.compilerEnv;
            bodygen.scriptOrFn = n;
            bodygen.scriptOrFnIndex = i;
            if (n instanceof FunctionNode) {
                bodygen.scriptOrFnType = "Lorg/mozilla/javascript/JSFunction;";
                bodygen.scriptOrFnClass = JSFUNCTION_CLASS_NAME;
            } else {
                bodygen.scriptOrFnType = "Lorg/mozilla/javascript/JSScript;";
                bodygen.scriptOrFnClass = "org.mozilla.javascript.JSScript";
            }
            bodygen.generateBodyCode();
            if (n.getType() != 124 || !(ofn = OptFunctionNode.get(n)).isTargetOfDirectCall()) continue;
            this.emitDirectConstructor(cfw, ofn);
            int pcount = ofn.fnode.getParamCount();
            if (pcount == 0) continue;
            this.emitNonDirectCall(cfw, ofn);
        }
        this.emitRegExpInit(cfw);
        this.emitTemplateLiteralInit(cfw);
        this.emitConstantDudeInitializers(cfw);
        return cfw.toByteArray();
    }

    private void emitNonDirectCall(ClassFileWriter cfw, OptFunctionNode ofn) {
        cfw.startMethod(this.getBodyMethodName(ofn.fnode), this.getNonDirectBodyMethodSIgnature(ofn.fnode), (short)9);
        cfw.addALoad(0);
        cfw.addALoad(1);
        cfw.addALoad(2);
        cfw.addALoad(3);
        cfw.addALoad(4);
        cfw.addALoad(5);
        int pcount = ofn.fnode.getParamCount();
        if (pcount != 0) {
            for (int p = 0; p != pcount; ++p) {
                cfw.add(190);
                cfw.addPush(p);
                int undefArg = cfw.acquireLabel();
                int beyond = cfw.acquireLabel();
                cfw.add(164, undefArg);
                cfw.addALoad(5);
                cfw.addPush(p);
                cfw.add(50);
                cfw.add(167, beyond);
                cfw.markLabel(undefArg);
                Codegen.pushUndefined(cfw);
                cfw.markLabel(beyond);
                cfw.adjustStackTop(-1);
                cfw.addPush(0.0);
                cfw.addALoad(5);
            }
        }
        cfw.addInvoke(184, this.mainClassName, this.getBodyMethodName(ofn.fnode), this.getBodyMethodSignature(ofn.fnode));
        cfw.add(176);
        cfw.stopMethod(6);
    }

    private void emitDirectConstructor(ClassFileWriter cfw, OptFunctionNode ofn) {
        cfw.startMethod(this.getDirectCtorName(ofn.fnode), this.getBodyMethodSignature(ofn.fnode), (short)9);
        int argCount = ofn.fnode.getParamCount();
        int firstLocal = 5 + argCount * 3 + 1;
        cfw.addALoad(1);
        cfw.add(192, JSFUNCTION_CLASS_NAME);
        cfw.addALoad(0);
        cfw.addALoad(3);
        cfw.addInvoke(182, "org/mozilla/javascript/BaseFunction", "createObject", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        cfw.addAStore(firstLocal);
        cfw.addALoad(0);
        cfw.addALoad(1);
        cfw.add(1);
        cfw.addALoad(2);
        cfw.addALoad(firstLocal);
        for (int i = 0; i < argCount; ++i) {
            cfw.addALoad(5 + i * 3);
            cfw.addDLoad(6 + i * 3);
        }
        cfw.addALoad(5 + argCount * 3);
        cfw.addInvoke(184, this.mainClassName, this.getBodyMethodName(ofn.fnode), this.getBodyMethodSignature(ofn.fnode));
        int exitLabel = cfw.acquireLabel();
        cfw.add(89);
        cfw.add(193, "org/mozilla/javascript/Scriptable");
        cfw.add(153, exitLabel);
        cfw.add(192, "org/mozilla/javascript/Scriptable");
        cfw.add(176);
        cfw.markLabel(exitLabel);
        cfw.addALoad(firstLocal);
        cfw.add(176);
        cfw.stopMethod((short)(firstLocal + 1));
    }

    static boolean isGenerator(ScriptNode node) {
        return node.getType() == 124 && ((FunctionNode)node).isGenerator();
    }

    private void generateLookupAccessor(ClassFileWriter cfw) {
        cfw.startMethod("getLookup", "()Ljava/lang/invoke/MethodHandles$Lookup;", (short)9);
        cfw.addInvoke(184, "java.lang.invoke.MethodHandles", "lookup", "()Ljava/lang/invoke/MethodHandles$Lookup;");
        cfw.add(176);
        cfw.stopMethod(0);
    }

    private void emitRegExpInit(ClassFileWriter cfw) {
        int totalRegCount = 0;
        for (int i = 0; i != this.scriptOrFnNodes.length; ++i) {
            totalRegCount += this.scriptOrFnNodes[i].getRegexpCount();
        }
        if (totalRegCount == 0) {
            return;
        }
        cfw.startMethod(REGEXP_INIT_METHOD_NAME, "(Lorg/mozilla/javascript/Context;)V", (short)9);
        cfw.addField("_reInitDone", "Z", (short)74);
        cfw.add(178, this.mainClassName, "_reInitDone", "Z");
        int doInit = cfw.acquireLabel();
        cfw.add(153, doInit);
        cfw.add(177);
        cfw.markLabel(doInit);
        cfw.addALoad(0);
        cfw.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "checkRegExpProxy", "(Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/RegExpProxy;");
        cfw.addAStore(1);
        for (int i = 0; i != this.scriptOrFnNodes.length; ++i) {
            ScriptNode n = this.scriptOrFnNodes[i];
            int regCount = n.getRegexpCount();
            for (int j = 0; j != regCount; ++j) {
                String reFieldName = this.getCompiledRegexpName(n, j);
                String reFieldType = "Ljava/lang/Object;";
                String reString = n.getRegexpString(j);
                String reFlags = n.getRegexpFlags(j);
                cfw.addField(reFieldName, reFieldType, (short)10);
                cfw.addALoad(1);
                cfw.addALoad(0);
                cfw.addPush(reString);
                if (reFlags == null) {
                    cfw.add(1);
                } else {
                    cfw.addPush(reFlags);
                }
                cfw.addInvoke(185, "org/mozilla/javascript/RegExpProxy", "compileRegExp", "(Lorg/mozilla/javascript/Context;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");
                cfw.add(179, this.mainClassName, reFieldName, reFieldType);
            }
        }
        cfw.addPush(1);
        cfw.add(179, this.mainClassName, "_reInitDone", "Z");
        cfw.add(177);
        cfw.stopMethod(2);
    }

    private void emitTemplateLiteralInit(ClassFileWriter cfw) {
        int totalTemplateLiteralCount = 0;
        for (ScriptNode n : this.scriptOrFnNodes) {
            totalTemplateLiteralCount += n.getTemplateLiteralCount();
        }
        cfw.startMethod(TEMPLATE_LITERAL_INIT_METHOD_NAME, TEMPLATE_LITERAL_INIT_METHOD_SIGNATURE, (short)9);
        cfw.addField("_qInitDone", "Z", (short)74);
        cfw.add(178, this.mainClassName, "_qInitDone", "Z");
        int doInit = cfw.acquireLabel();
        cfw.add(153, doInit);
        cfw.add(177);
        cfw.markLabel(doInit);
        for (ScriptNode n : this.scriptOrFnNodes) {
            int qCount = n.getTemplateLiteralCount();
            if (qCount == 0) continue;
            String qFieldName = this.getTemplateLiteralName(n);
            String qFieldType = "[Ljava/lang/Object;";
            cfw.addField(qFieldName, qFieldType, (short)10);
            cfw.addPush(qCount);
            cfw.add(189, "java/lang/Object");
            for (int j = 0; j < qCount; ++j) {
                List<TemplateCharacters> strings = n.getTemplateLiteralStrings(j);
                cfw.add(89);
                cfw.addPush(j);
                cfw.addPush(strings.size() * 2);
                cfw.add(189, "java/lang/String");
                int k = 0;
                for (TemplateCharacters s : strings) {
                    cfw.add(89);
                    cfw.addPush(k++);
                    if (s.getValue() != null) {
                        cfw.addPush(s.getValue());
                    } else {
                        cfw.add(1);
                    }
                    cfw.add(83);
                    cfw.add(89);
                    cfw.addPush(k++);
                    cfw.addPush(s.getRawValue());
                    cfw.add(83);
                }
                cfw.add(83);
            }
            cfw.add(179, this.mainClassName, qFieldName, qFieldType);
        }
        cfw.addPush(true);
        cfw.add(179, this.mainClassName, "_qInitDone", "Z");
        cfw.add(177);
        cfw.stopMethod(0);
    }

    private void emitConstantDudeInitializers(ClassFileWriter cfw) {
        int N = this.itsConstantListSize;
        if (N == 0) {
            return;
        }
        cfw.startMethod("<clinit>", TEMPLATE_LITERAL_INIT_METHOD_SIGNATURE, (short)24);
        double[] array = this.itsConstantList;
        for (int i = 0; i != N; ++i) {
            double num = array[i];
            String constantName = "_k" + i;
            String constantType = Codegen.getStaticConstantWrapperType(num);
            cfw.addField(constantName, constantType, (short)10);
            int inum = (int)num;
            if ((double)inum == num) {
                cfw.addPush(inum);
                cfw.addInvoke(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            } else {
                cfw.addPush(num);
                Codegen.addDoubleWrap(cfw);
            }
            cfw.add(179, this.mainClassName, constantName, constantType);
        }
        cfw.add(177);
        cfw.stopMethod(0);
    }

    void pushNumberAsObject(ClassFileWriter cfw, double num) {
        if (num == 0.0) {
            if (1.0 / num > 0.0) {
                cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "zeroObj", "Ljava/lang/Integer;");
            } else {
                cfw.addPush(num);
                Codegen.addDoubleWrap(cfw);
            }
        } else {
            if (num == 1.0) {
                cfw.add(178, "org/mozilla/javascript/optimizer/OptRuntime", "oneObj", "Ljava/lang/Integer;");
                return;
            }
            if (num == -1.0) {
                cfw.add(178, "org/mozilla/javascript/optimizer/OptRuntime", "minusOneObj", "Ljava/lang/Integer;");
            } else if (Double.isNaN(num)) {
                cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "NaNobj", "Ljava/lang/Double;");
            } else if (this.itsConstantListSize >= 2000) {
                cfw.addPush(num);
                Codegen.addDoubleWrap(cfw);
            } else {
                int index;
                int N = this.itsConstantListSize;
                if (N == 0) {
                    this.itsConstantList = new double[64];
                } else {
                    double[] array = this.itsConstantList;
                    for (index = 0; index != N && array[index] != num; ++index) {
                    }
                    if (N == array.length) {
                        array = new double[N * 2];
                        System.arraycopy(this.itsConstantList, 0, array, 0, N);
                        this.itsConstantList = array;
                    }
                }
                if (index == N) {
                    this.itsConstantList[N] = num;
                    this.itsConstantListSize = N + 1;
                }
                String constantName = "_k" + index;
                String constantType = Codegen.getStaticConstantWrapperType(num);
                cfw.add(178, this.mainClassName, constantName, constantType);
            }
        }
    }

    private static void addDoubleWrap(ClassFileWriter cfw) {
        cfw.addInvoke(184, "org/mozilla/javascript/optimizer/OptRuntime", "wrapDouble", "(D)Ljava/lang/Double;");
    }

    private static String getStaticConstantWrapperType(double num) {
        int inum = (int)num;
        if ((double)inum == num) {
            return "Ljava/lang/Integer;";
        }
        return "Ljava/lang/Double;";
    }

    static void pushUndefined(ClassFileWriter cfw) {
        cfw.add(178, "org/mozilla/javascript/Undefined", "instance", "Ljava/lang/Object;");
    }

    int getIndex(ScriptNode n) {
        return this.scriptOrFnIndexes.get(n);
    }

    String getDirectCtorName(ScriptNode n) {
        return "_n" + this.getIndex(n);
    }

    String getBodyMethodName(ScriptNode n) {
        return this.getBodyMethodName(n, this.getIndex(n));
    }

    String getBodyMethodName(ScriptNode n, int index) {
        return "_c_" + this.cleanName(n) + "_" + index;
    }

    String cleanName(ScriptNode n) {
        Name name;
        String result = "";
        result = n instanceof FunctionNode ? ((name = ((FunctionNode)n).getFunctionName()) == null ? "anonymous" : name.getIdentifier()) : "script";
        return result;
    }

    String getNonDirectBodyMethodSIgnature(ScriptNode n) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append("Lorg/mozilla/javascript/Context;");
        if (n instanceof FunctionNode) {
            sb.append("Lorg/mozilla/javascript/JSFunction;");
        } else {
            sb.append("Lorg/mozilla/javascript/JSScript;");
        }
        sb.append("Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;");
        sb.append("[Ljava/lang/Object;)Ljava/lang/Object;");
        return sb.toString();
    }

    String getBodyMethodSignature(ScriptNode n) {
        OptFunctionNode ofn;
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append("Lorg/mozilla/javascript/Context;");
        if (n instanceof FunctionNode) {
            sb.append("Lorg/mozilla/javascript/JSFunction;");
        } else {
            sb.append("Lorg/mozilla/javascript/JSScript;");
        }
        sb.append("Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;");
        if (n.getType() == 124 && (ofn = OptFunctionNode.get(n)).isTargetOfDirectCall()) {
            int pCount = ofn.fnode.getParamCount();
            for (int i = 0; i != pCount; ++i) {
                sb.append("Ljava/lang/Object;D");
            }
        }
        sb.append("[Ljava/lang/Object;)Ljava/lang/Object;");
        return sb.toString();
    }

    String getCodeInitMethodName(OptFunctionNode ofn) {
        return "_i" + this.getIndex(ofn.fnode);
    }

    String getCompiledRegexpName(ScriptNode n, int regexpIndex) {
        return "_re" + this.getIndex(n) + "_" + regexpIndex;
    }

    String getTemplateLiteralName(ScriptNode n) {
        return "_q" + this.getIndex(n);
    }

    static RuntimeException badTree() {
        throw new RuntimeException("Bad tree in codegen");
    }

    public void setMainMethodClass(String className) {
        this.mainMethodClass = className;
    }

    private static class CompilationResult<T extends ScriptOrFn<T>> {
        final JSDescriptor.Builder<T> builder;
        final String className;
        final byte[] bytecode;
        final OptJSCode.BuilderEnv builderEnv;

        CompilationResult(JSDescriptor.Builder<T> builder, String className, byte[] bytecode, OptJSCode.BuilderEnv builderEnv) {
            this.builder = builder;
            this.className = className;
            this.bytecode = bytecode;
            this.builderEnv = builderEnv;
        }
    }
}

