/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.SlotMap;
import org.mozilla.javascript.SlotMapOwner;

public class CompoundOperationMap
implements SlotMap,
AutoCloseable {
    protected final SlotMapOwner owner;
    protected SlotMap map;
    boolean touched = false;

    public CompoundOperationMap(SlotMapOwner owner) {
        this.owner = owner;
        this.map = owner.getMap();
    }

    protected void updateMap(boolean resetTouched) {
        if (this.touched) {
            this.map = this.owner.getMap();
            this.touched = resetTouched ? false : this.touched;
        }
    }

    public boolean isTouched() {
        return this.touched;
    }

    @Override
    public void add(SlotMapOwner owner, Slot newSlot) {
        this.map.add(owner, newSlot);
        this.touched = true;
    }

    @Override
    public <S extends Slot> S compute(SlotMapOwner owner, Object key, int index, SlotMap.SlotComputer<S> compute) {
        this.updateMap(true);
        S res = this.map.compute(owner, this, key, index, compute);
        this.touched = true;
        return res;
    }

    @Override
    public <S extends Slot> S compute(SlotMapOwner owner, CompoundOperationMap compoundOp, Object key, int index, SlotMap.SlotComputer<S> compute) {
        assert (compoundOp == this);
        this.updateMap(true);
        S res = this.map.compute(owner, this, key, index, compute);
        this.touched = true;
        return res;
    }

    @Override
    public int dirtySize() {
        this.updateMap(false);
        return this.map.dirtySize();
    }

    @Override
    public boolean isEmpty() {
        this.updateMap(false);
        return this.map.isEmpty();
    }

    @Override
    public Slot modify(SlotMapOwner owner, Object key, int index, int attributes) {
        this.updateMap(true);
        Slot res = this.map.modify(owner, key, index, attributes);
        this.touched = true;
        return res;
    }

    @Override
    public Slot query(Object key, int index) {
        this.updateMap(false);
        return this.map.query(key, index);
    }

    @Override
    public int size() {
        this.updateMap(false);
        return this.map.size();
    }

    @Override
    public Iterator<Slot> iterator() {
        this.updateMap(false);
        return this.map.iterator();
    }

    @Override
    public void close() {
    }
}

