/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.util.Map;
import javax.jws.HandlerChain;
import org.apache.cxf.annotations.DataBinding;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.HandlerConfigGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.WSDLToJavaProcessor;

public class SEIGenerator
extends AbstractJAXWSGenerator {
    private static final String SEI_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/sei.vm";

    public SEIGenerator() {
        this.name = "sei.generator";
    }

    @Override
    public boolean passthrough() {
        if (this.env.optionSet("genSEI") || this.env.optionSet("all")) {
            return false;
        }
        return this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genServer") || this.env.optionSet("genService") || this.env.optionSet("genFault");
    }

    private boolean hasHandlerConfig(JavaInterface intf) {
        return intf.getHandlerChains() != null;
    }

    @Override
    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        if (this.passthrough()) {
            return;
        }
        Map map = CastUtils.cast((Map)((Map)penv.get(WSDLToJavaProcessor.MODEL_MAP)));
        for (JavaModel javaModel : map.values()) {
            Map interfaces = javaModel.getInterfaces();
            if (interfaces.isEmpty()) {
                ServiceInfo serviceInfo = (ServiceInfo)this.env.get(ServiceInfo.class);
                String wsdl = serviceInfo.getDescription().getBaseURI();
                Message msg = new Message("CAN_NOT_GEN_SEI", LOG, new Object[]{wsdl});
                if (!penv.isVerbose()) continue;
                System.out.println(msg.toString());
                continue;
            }
            for (JavaInterface intf : interfaces.values()) {
                if (this.hasHandlerConfig(intf)) {
                    HandlerConfigGenerator handlerGen = new HandlerConfigGenerator();
                    handlerGen.setJavaInterface(intf);
                    handlerGen.generate(this.getEnvironment());
                    JAnnotation annot = handlerGen.getHandlerAnnotation();
                    if (handlerGen.getHandlerAnnotation() != null) {
                        boolean existHandlerAnno = false;
                        for (JAnnotation jann : intf.getAnnotations()) {
                            if (jann.getType() != HandlerChain.class) continue;
                            existHandlerAnno = true;
                        }
                        if (!existHandlerAnno) {
                            intf.addAnnotation(annot);
                            intf.addImport("javax.jws.HandlerChain");
                        }
                    }
                }
                if (penv.containsKey("databinding-class")) {
                    JAnnotation ann = new JAnnotation(DataBinding.class);
                    JAnnotationElement el = new JAnnotationElement(null, penv.get("databinding-class"), true);
                    ann.addElement(el);
                    intf.addAnnotation(ann);
                }
                this.clearAttributes();
                this.setAttributes("intf", intf);
                Object seiSc = "";
                for (String s : intf.getSuperInterfaces()) {
                    seiSc = !((String)seiSc).isEmpty() ? (String)seiSc + ", " : "extends ";
                    seiSc = (String)seiSc + s;
                }
                if (!StringUtils.isEmpty((String)seiSc)) {
                    seiSc = (String)seiSc + " ";
                }
                this.setAttributes("seiSuperinterfaceString", seiSc);
                this.setCommonAttributes();
                this.doWrite(SEI_TEMPLATE, this.parseOutputName(intf.getPackageName(), intf.getName()));
            }
        }
    }

    @Override
    public void register(ClassCollector collector, String packageName, String fileName) {
        collector.addSeiClassName(packageName, fileName, packageName + "." + fileName);
    }
}

