/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro.mapreduce;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.avro.AvroColumnWriter;

public abstract class AvroTrevniRecordWriterBase<K, V, T>
extends RecordWriter<K, V> {
    public static final String EXT = ".trv";
    public static final String META_PREFIX = "trevni.meta.";
    protected int part = 0;
    protected AvroColumnWriter<T> writer;
    final Path dirPath;
    final FileSystem fs;
    final long blockSize;
    protected Schema schema;
    protected ColumnFileMetaData meta;

    public AvroTrevniRecordWriterBase(TaskAttemptContext context) throws IOException {
        this.schema = this.initSchema(context);
        this.meta = AvroTrevniRecordWriterBase.filterMetadata(context.getConfiguration());
        this.writer = new AvroColumnWriter(this.schema, this.meta, (GenericData)ReflectData.get());
        Path outputPath = FileOutputFormat.getOutputPath((JobContext)context);
        String dir = FileOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)"part", (String)"");
        this.dirPath = new Path(outputPath.toString() + "/" + dir);
        this.fs = this.dirPath.getFileSystem(context.getConfiguration());
        this.fs.mkdirs(this.dirPath);
        this.blockSize = this.fs.getDefaultBlockSize(this.dirPath);
    }

    protected abstract Schema initSchema(TaskAttemptContext var1);

    public void flush() throws IOException {
        try (FSDataOutputStream out = this.fs.create(new Path(this.dirPath, "part-" + this.part++ + EXT));){
            this.writer.writeTo((OutputStream)out);
        }
        this.writer = new AvroColumnWriter(this.schema, this.meta, (GenericData)ReflectData.get());
    }

    public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
        this.flush();
    }

    static ColumnFileMetaData filterMetadata(Configuration configuration) {
        ColumnFileMetaData meta = new ColumnFileMetaData();
        for (Map.Entry confEntry : configuration) {
            if (!((String)confEntry.getKey()).startsWith(META_PREFIX)) continue;
            meta.put((Object)((String)confEntry.getKey()).substring(META_PREFIX.length()), (Object)((String)confEntry.getValue()).getBytes(StandardCharsets.UTF_8));
        }
        return meta;
    }
}

